/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.fees.bos;

import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTImpuestoDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTMinValoresDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTMinimoDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTPrecioDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTRevenueDTO;
import java.util.ArrayList;
import java.util.List;

public class FeesTransaccionUtileria {
    public static String[] anios;

    public static String[][] obtenerDatosImpuesto(List<FeesTImpuestoDTO> impuestos, List<FeesTImpuestoDTO> paises) {
        int i;
        String[][] datos = new String[3][paises.size()];
        if (impuestos != null && !impuestos.isEmpty()) {
            for (i = 0; i < paises.size(); ++i) {
                datos[0][i] = paises.get(i).getImpuesto();
                for (int j = 0; j < impuestos.size(); ++j) {
                    if (paises.get(i).getIdPais().longValue() != impuestos.get(j).getIdPais().longValue()) continue;
                    datos[1][i] = impuestos.get(j).getAplica() == 1 ? "true" : "false";
                    datos[2][i] = impuestos.get(j).getIncluido() == 1 ? "true" : "false";
                }
            }
        } else {
            for (i = 0; i < paises.size(); ++i) {
                datos[0][i] = paises.get(i).getImpuesto();
                datos[1][i] = "false";
                datos[2][i] = "false";
            }
        }
        for (i = 0; i < paises.size(); ++i) {
            if (datos[1][i] == null) {
                datos[1][i] = "false";
            }
            if (datos[2][i] != null) continue;
            datos[2][i] = "false";
        }
        return datos;
    }

    public static String[][] obtenerDatosPrecio(String[] formatos, List<FeesTImpuestoDTO> paises, String[] variable, List<Integer> numeroReg, List<FeesTPrecioDTO> precios) {
        String[][] datos;
        block13: {
            int j;
            int i;
            block12: {
                datos = null;
                if (numeroReg != null && !numeroReg.isEmpty()) break block12;
                datos = new String[variable.length * formatos.length][paises.size() * 2 + 2];
                int indFilaPais = 0;
                for (int i2 = 0; i2 < variable.length; ++i2) {
                    boolean primero = true;
                    for (int j2 = 0; j2 < formatos.length; ++j2) {
                        if (primero) {
                            datos[indFilaPais][0] = variable[i2];
                        }
                        datos[indFilaPais][1] = formatos[j2];
                        ++indFilaPais;
                    }
                }
                break block13;
            }
            datos = new String[variable.length * formatos.length][paises.size() * 2 + 2];
            Long pais = 0L;
            int indFilaPais = 0;
            int indColPais = 0;
            for (int i3 = 0; i3 < precios.size(); ++i3) {
                if (pais.longValue() != precios.get(i3).getIdPais().longValue()) {
                    for (int j3 = 0; j3 < paises.size(); ++j3) {
                        if (precios.get(i3).getIdPais().longValue() != paises.get(j3).getIdPais().longValue()) continue;
                        pais = paises.get(j3).getIdPais();
                        indColPais = j3;
                        break;
                    }
                    indFilaPais = 0;
                }
                datos[indFilaPais][0] = precios.get(i3).getRelease();
                datos[indFilaPais][1] = precios.get(i3).getFormato();
                datos[indFilaPais][indColPais * 2 + 2] = precios.get(i3).getMoneda();
                datos[indFilaPais][indColPais * 2 + 3] = precios.get(i3).getDolar();
                ++indFilaPais;
            }
            if (numeroReg.get(0) == variable.length) break block13;
            ArrayList<String> faltantes = new ArrayList<String>();
            int indNulo = 0;
            for (i = 0; i < variable.length; ++i) {
                boolean existe = false;
                for (j = 0; j < datos.length; ++j) {
                    if (datos[j][0] != null && datos[j][0].compareTo(variable[i]) == 0) {
                        existe = true;
                        break;
                    }
                    if (indNulo != 0 || datos[j][0] != null) continue;
                    indNulo = j;
                }
                if (existe) continue;
                faltantes.add(variable[i]);
            }
            for (i = 0; i < faltantes.size(); ++i) {
                boolean primero = true;
                for (j = 0; j < formatos.length; ++j) {
                    if (primero) {
                        datos[indNulo][0] = (String)faltantes.get(i);
                    }
                    datos[indNulo][1] = formatos[j];
                    ++indNulo;
                }
            }
        }
        return datos;
    }

    public static String[][] obtenerDatosRevenue(List<FeesTRevenueDTO> revenue, String[] variable) {
        String[][] datos = null;
        if (revenue != null && !revenue.isEmpty()) {
            datos = new String[revenue.size()][3];
            for (int i = 0; i < revenue.size(); ++i) {
                datos[i][0] = revenue.get(i).getRelease();
                datos[i][1] = revenue.get(i).getDdaPto();
                datos[i][2] = revenue.get(i).getEstudioPto();
            }
        } else {
            datos = new String[variable.length][3];
            for (int i = 0; i < variable.length; ++i) {
                datos[i][0] = variable[i];
                datos[i][1] = null;
                datos[i][2] = null;
            }
        }
        return datos;
    }

    public static String[][] obtenerDatosMinimos(List<FeesTMinValoresDTO> valoresAnio, List<FeesTMinimoDTO> valoresCat) {
        String[][] datos;
        block4: {
            block3: {
                datos = null;
                if (valoresAnio == null || valoresAnio.isEmpty()) break block3;
                datos = new String[1][valoresAnio.size()];
                anios = new String[valoresAnio.size()];
                for (int i = 0; i < valoresAnio.size(); ++i) {
                    datos[0][i] = String.valueOf(valoresAnio.get(i).getValor());
                    FeesTransaccionUtileria.anios[i] = valoresAnio.get(i).getInicio() + "-" + valoresAnio.get(i).getFin();
                }
                break block4;
            }
            if (valoresCat == null || valoresCat.isEmpty()) break block4;
            datos = new String[valoresCat.size()][valoresCat.get(0).getValores().size() + 3];
            anios = new String[valoresCat.get(0).getValores().size()];
            for (int i = 0; i < valoresCat.size(); ++i) {
                datos[i][0] = String.valueOf(valoresCat.get(i).getDesde());
                datos[i][1] = String.valueOf(valoresCat.get(i).getHasta());
                datos[i][2] = String.valueOf(valoresCat.get(i).getCategoria());
                for (int j = 0; j < valoresCat.get(i).getValores().size(); ++j) {
                    datos[i][j + 3] = String.valueOf(((FeesTMinValoresDTO)valoresCat.get(i).getValores().get(j)).getValor());
                    if (i != 0) continue;
                    FeesTransaccionUtileria.anios[j] = ((FeesTMinValoresDTO)valoresCat.get(i).getValores().get(j)).getInicio() + "-" + ((FeesTMinValoresDTO)valoresCat.get(i).getValores().get(j)).getFin();
                }
            }
        }
        return datos;
    }

    public static FeesTMinimoDTO generearMinimoDTO(String desde, String hasta, String categoria, String seccion, Integer revenue, Long id) {
        FeesTMinimoDTO min = new FeesTMinimoDTO();
        if (desde != null) {
            min.setDesde(Double.valueOf(Double.parseDouble(desde)));
        }
        if (hasta != null) {
            min.setHasta(Double.valueOf(Double.parseDouble(hasta)));
        }
        min.setCategoria(categoria);
        min.setSeccion(seccion);
        min.setRevenue(String.valueOf(revenue));
        min.setIdCategoria(id);
        return min;
    }

    public static FeesTMinValoresDTO generearValorMinimoDTO(String fecha, Long idCategoria, String valor, String seccion) {
        FeesTMinValoresDTO min = new FeesTMinValoresDTO();
        min.setInicio(fecha.split("-")[0]);
        min.setFin(fecha.split("-")[1]);
        min.setValor(Double.valueOf(Double.parseDouble(valor)));
        min.setIdCat(idCategoria);
        min.setSeccion(seccion);
        return min;
    }

    public static FeesTImpuestoDTO generearFeesTImpuestoDTO(Long idPais, String aplica, String incluido, String seccion) {
        FeesTImpuestoDTO impuesto = new FeesTImpuestoDTO();
        impuesto.setIdPais(idPais);
        Integer ap = aplica.compareTo("true") == 0 ? 1 : 0;
        impuesto.setAplica(ap);
        Integer inc = incluido.compareTo("true") == 0 ? 1 : 0;
        impuesto.setIncluido(inc);
        impuesto.setSeccion(seccion);
        return impuesto;
    }

    public static FeesTPrecioDTO generearFeesTPrecioDTO(Long idRelease, Long idFormato, Long idPais, String moneda, String dolar) {
        FeesTPrecioDTO precio = new FeesTPrecioDTO();
        precio.setIdRelease(idRelease);
        precio.setIdFormato(idFormato);
        precio.setIdPais(idPais);
        precio.setDolar(dolar);
        precio.setMoneda(moneda);
        return precio;
    }

    public static FeesTRevenueDTO generearFeesTRevenueDTO(Long idRelease, String dda, String estudio) {
        FeesTRevenueDTO revenue = new FeesTRevenueDTO();
        revenue.setDdaPto(dda);
        revenue.setEstudioPto(estudio);
        revenue.setIdRelease(idRelease);
        return revenue;
    }
}

