/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.transaccion.terminos.daos.TerminosTransaccionDAO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.ExcepcionesSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsPeriodoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PeriodoTipos;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminosAuxiliarDTO;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TerminosExcepciones
extends BaseBO {
    @Autowired
    private TerminosTransaccionDAO dao;
    @Autowired
    private FeesContratoDAO feesDao;

    public ExcepcionesSeccionDTO obtenerExcepciones(Long idContrato, String seccion) {
        ExcepcionesSeccionDTO excepcionesSeccionDTO = new ExcepcionesSeccionDTO();
        List datos = this.dao.obtenerExcepcionesDatos(idContrato, seccion);
        List headers = this.dao.obtenerPeriodos(idContrato, seccion, PeriodoTipos.EXCEPCION.getDesc());
        List titulos = this.dao.obtenerExcepcionesTitulos(idContrato, seccion);
        String[][] excepciones = new String[][]{{null, null, null, null}};
        String[][] titulosExcepcion = new String[][]{{null, null, null, null}};
        String[] periodos = new String[]{this.feesDao.fechaInicio(idContrato) + "-" + this.feesDao.fechaFin(idContrato)};
        if (datos != null && !datos.isEmpty() && headers != null && !headers.isEmpty()) {
            periodos = new String[headers.size()];
            excepciones = new String[datos.size() / periodos.length][periodos.length * 2 + 2];
            HashMap<Long, ArrayList<Object>> mapa = new HashMap<Long, ArrayList<Object>>();
            for (Object titulo : datos) {
                Long l = titulo.getId();
                ArrayList<Object> excepcion = (ArrayList<Object>)mapa.get(l);
                if (excepcion == null) {
                    excepcion = new ArrayList<Object>();
                }
                excepcion.add(titulo);
                mapa.put(l, excepcion);
            }
            int x = 0;
            for (Map.Entry entry : mapa.entrySet()) {
                Long key = (Long)entry.getKey();
                List value = (List)entry.getValue();
                Collections.sort(value, new Comparator<TerminosAuxiliarDTO>(){

                    @Override
                    public int compare(TerminosAuxiliarDTO s1, TerminosAuxiliarDTO s2) {
                        return s1.getFechaInicio().compareTo(s2.getFechaInicio());
                    }
                });
                int y = 0;
                for (TerminosAuxiliarDTO val : value) {
                    excepciones[x][0] = val.getId() != null ? val.getId().toString() : null;
                    excepciones[x][1] = val.getNombre();
                    excepciones[x][y * 2 + 2] = val.getpDda() != null ? val.getpDda().toString() : null;
                    excepciones[x][y * 2 + 3] = val.getpEstudio() != null ? val.getpEstudio().toString() : null;
                    periodos[y] = val.getFechaInicio() + "-" + val.getFechaFin();
                    ++y;
                }
                ++x;
            }
        }
        if (titulos != null && !titulos.isEmpty()) {
            titulosExcepcion = new String[titulos.size()][periodos.length * 2 + 2];
            int x = 0;
            for (Object titulo : titulos) {
                titulosExcepcion[x][0] = titulo.getId() != null ? titulo.getId().toString() : null;
                titulosExcepcion[x][1] = titulo.getNombre();
                for (int i = 2; i < titulosExcepcion[x].length; ++i) {
                    titulosExcepcion[x][i] = null;
                }
                ++x;
            }
        }
        excepcionesSeccionDTO.setExcepciones(excepciones);
        excepcionesSeccionDTO.setPeriodos(periodos);
        excepcionesSeccionDTO.setTitulos(titulosExcepcion);
        return excepcionesSeccionDTO;
    }

    public void guardarExcepciones(Long idContrato, String seccion, ExcepcionesSeccionDTO revenue) {
        if (revenue != null) {
            Long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
            ArrayList<FsPeriodoDTO> pers = new ArrayList<FsPeriodoDTO>();
            ArrayList<TerminosAuxiliarDTO> excepciones = new ArrayList<TerminosAuxiliarDTO>();
            if (revenue.getPeriodos() != null && revenue.getExcepciones() != null && revenue.getExcepciones().length > 0 && revenue.getPeriodos().length > 0) {
                int i;
                for (i = 0; i < revenue.getPeriodos().length; ++i) {
                    String[] periodosExc = revenue.getPeriodos()[i].split("-");
                    FsPeriodoDTO periodo = new FsPeriodoDTO();
                    periodo.setFechaInicio(periodosExc[0]);
                    periodo.setFechaFin(periodosExc[1]);
                    periodo.setIdSeccion(idSeccion);
                    periodo.setIdContrato(idContrato);
                    periodo.setTipo(PeriodoTipos.EXCEPCION.getDesc());
                    this.dao.guardarPeridoMinimos(periodo);
                    pers.add(periodo);
                }
                for (i = 0; i < revenue.getExcepciones().length; ++i) {
                    for (int j = 0; j < pers.size(); ++j) {
                        TerminosAuxiliarDTO t = new TerminosAuxiliarDTO();
                        t.setId(((FsPeriodoDTO)pers.get(j)).getIdPeriodo());
                        t.setIdOpcionalA(new Long(revenue.getExcepciones()[i][0]));
                        if (revenue.getExcepciones()[i][j * 2 + 2] != null) {
                            t.setpDda(revenue.getExcepciones()[i][j * 2 + 2]);
                        }
                        if (revenue.getExcepciones()[i][j * 2 + 3] != null) {
                            t.setpEstudio(revenue.getExcepciones()[i][j * 2 + 3]);
                        }
                        t.setIdOpcionalB(idSeccion);
                        excepciones.add(t);
                    }
                }
                this.dao.guardarExcepciones(excepciones);
            }
        }
    }

    public void eliminarExcepcion(Long idContrato, String seccion) {
        this.dao.eliminarExcepcion(idContrato, seccion);
    }
}

