/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosExcepciones;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosMinimos;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosPrecio;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosRelease;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosRevenue;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.ExcepcionesSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.MinimoGarantizadoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PrecioRentaDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PremiumDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.RevenueSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.SeccionesTerminos;
import com.mx.dla.global.bos.BaseBO;
import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminosPremier
extends BaseBO {
    @Autowired
    private TerminosMinimos minimos;
    @Autowired
    private TerminosRelease release;
    @Autowired
    @Qualifier(value="precioPremier")
    private TerminosPrecio precio;
    @Autowired
    private TerminosRevenue revenue;
    @Autowired
    private TerminosExcepciones excepciones;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public PremiumDTO obtenerPremium(Long idContrato) throws TransaccionException {
        PremiumDTO premium = new PremiumDTO();
        try {
            MinimoGarantizadoDTO minimo = this.minimos.obtenerMinimos(idContrato, SeccionesTerminos.RentaPremier.getDesc());
            String[][] releasesDatos = this.release.obtenerRelease(idContrato, SeccionesTerminos.RentaPremier.getDesc());
            PrecioRentaDTO precioDTO = this.precio.obtenerPrecio(releasesDatos, idContrato, SeccionesTerminos.RentaPremier.getDesc());
            RevenueSeccionDTO revenueDTO = this.revenue.obtenerRevenue(idContrato, SeccionesTerminos.RentaPremier.getDesc(), releasesDatos);
            ExcepcionesSeccionDTO excepcionesDTO = this.excepciones.obtenerExcepciones(idContrato, SeccionesTerminos.RentaPremier.getDesc());
            premium.setMinimos(minimo);
            premium.setRelease(releasesDatos);
            premium.setPrecio(precioDTO);
            premium.setRevenue(revenueDTO);
            premium.setExcepciones(excepcionesDTO);
        }
        catch (Exception e) {
            new TransaccionException("Error al obtener terminos premium.", e);
        }
        return premium;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void guardarPremium(PremiumDTO p, Long idContrato) throws JsonParseException, JsonMappingException, IOException, TransaccionException {
        try {
            this.logger.debug(p.toString());
            this.precio.eliminarPaisesImpuestoEstatus(idContrato, SeccionesTerminos.RentaPremier.getDesc());
            this.precio.eliminarPreciosPremium(idContrato, SeccionesTerminos.RentaPremier.getDesc());
            this.revenue.eliminarRevenue(idContrato, SeccionesTerminos.RentaPremier.getDesc());
            this.minimos.guardarMinimos(p.getMinimos().getMinimosCateg(), p.getMinimos().getMinimosAnio(), p.getMinimos().getAnios(), p.getMinimos().getTipoMin(), SeccionesTerminos.RentaPremier.getDesc(), idContrato);
            this.release.guardarRelease(p.getRelease(), idContrato, SeccionesTerminos.RentaPremier.getDesc());
            this.precio.actualizarPrecioAplica(idContrato, SeccionesTerminos.RentaPremier.getDesc(), p.getPrecio().getAplica());
            this.precio.actualizarPagoPpe(idContrato, SeccionesTerminos.RentaPremier.getDesc(), p.getPrecio().getPagoPPE());
            if (p.getPrecio().getAplica() == 1) {
                this.precio.guardarDatosPrecios(p.getPrecio(), this.release.getIds(), idContrato, SeccionesTerminos.RentaPremier.getDesc());
            }
            this.revenue.guardarRevenue(idContrato, SeccionesTerminos.RentaPremier.getDesc(), this.release.getIds(), p.getRevenue());
            this.excepciones.guardarExcepciones(idContrato, SeccionesTerminos.RentaPremier.getDesc(), p.getExcepciones());
        }
        catch (Exception e) {
            new TransaccionException("Error al obtener terminos premium.", e);
        }
    }
}

