/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.titulos.bos;

import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.enums.Estatus;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.transaccion.titulos.bos.TituloTranUtil;
import com.mx.dla.dda.contrato.transaccion.titulos.bos.TitulosBussinesTranBO;
import com.mx.dla.dda.contrato.transaccion.titulos.daos.TituloTransDAO;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransDB;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransaccionDTO;
import com.mx.dla.dda.general.utilerias.ListaUtilerias;
import com.mx.dla.global.bos.BaseBO;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TituloTranRules
extends BaseBO {
    @Autowired
    private TitulosBussinesTranBO titulosBussinesBO;
    @Autowired
    private TituloTransDAO tituloDAO;
    @Autowired
    private GeneralesDAO generalesDAO;

    public void validaEntrada(TituloTransaccionDTO titulo) throws Exception {
        this.validaVentanaTitulo(titulo);
        this.validaHvrdTitulo(titulo, Arrays.asList(titulo));
    }

    public void validaHvrdTitulo(TituloTransaccionDTO cambio, List<TituloTransaccionDTO> validaEn) throws TituloException, Exception {
        this.logger.info("cambio: {}", (Object)cambio);
        this.logger.info("validaEn: {}", validaEn);
        for (TituloTransaccionDTO item : ListaUtilerias.safeList(validaEn)) {
            this.logger.info("cambio.getHvrd(): {}", (Object)cambio.getHvrd());
            this.logger.info("item.getFechaInicio(): {}", (Object)item.getFechaInicio());
            if (cambio.getHvrd() == null || item.getFechaInicio() == null || !cambio.getHvrd().after(item.getFechaInicio())) continue;
            this.logger.info("Se cumple!!");
            throw new TituloException("Fecha HVRD no puede ser posterior a Fecha inicio");
        }
    }

    public void validaVentanaTitulo(TituloTransaccionDTO titulo) throws TituloException, Exception {
        List titulos = null;
        List tmirror = null;
        ContratoDTO fechas = this.titulosBussinesBO.calculaFechasInicioFinValidacion(titulo.getIdContrato());
        ContratoDTO contrato = this.generalesDAO.obtenerContrato(titulo.getIdContrato());
        contrato.setIdEstatus(Estatus.Vigente.getValor());
        this.logger.info("{}", (Object)TituloTranUtil.getTituloType(titulo));
        titulo.setTypeTitulo(TituloTranUtil.getTituloType(titulo));
        this.logger.info("validaVentanaTitulo: {}", (Object)titulo);
        if (titulo.getFechaInicio() != null && titulo.getFechaFin() != null && titulo.getFechaFin().before(titulo.getFechaInicio())) {
            throw new TituloException("Fecha fin no puede ser anterior a Fecha inicio");
        }
        if (titulo.getFechaInicio() != null && (fechas.getFechaInicio().after(titulo.getFechaInicio()) || fechas.getFechaFin().before(titulo.getFechaInicio()))) {
            throw new TituloException("Fecha de exhibici\u00f3n fuera de rango");
        }
        titulos = this.tituloDAO.titulosVentanaEnContrato(titulo, contrato, "T");
        this.logger.info(": {}", (Object)titulos);
        tmirror = this.tituloDAO.titulosVentanaEnContrato(titulo, contrato, "M");
        this.logger.info(": {}", (Object)tmirror);
        if (titulos != null && titulos.size() > 0 || tmirror != null && tmirror.size() > 0) {
            throw new TituloException("Este t\u00edtulo se encuentra en este periodo en exhibici\u00f3n en el contrato.");
        }
        titulos = this.tituloDAO.titulosVentanaEnNoTransaccionales(titulo, contrato);
        this.logger.info(": {}", (Object)titulos);
        if (titulos != null && titulos.size() > 0) {
            throw new TituloException("Este t\u00edtulo se encuentra en este periodo en exhibici\u00f3n en un contrato no transaccional (" + ((TituloTransDB)titulos.get(0)).getNombreEstandar() + ")");
        }
        titulos = this.tituloDAO.titulosVentanaEnTransaccionales(titulo, contrato);
        this.logger.info(": {}", (Object)titulos);
        if (titulos != null && titulos.size() > 0) {
            throw new TituloException("Este t\u00edtulo se encuentra en este periodo en exhibici\u00f3n en otro contrato transaccional (" + ((TituloTransDB)titulos.get(0)).getNombreEstandar() + ")");
        }
    }

    private void validaTituloDuplicado(Long idTitulo, Long idLista, TituloTransaccionDTO titulo) throws TituloException {
        Integer encontrados = null;
        try {
            encontrados = this.tituloDAO.buscarTitulosPorDescripcionEnLista(idLista, titulo.getIdTituloCnt(), titulo.getNombreUnico(), titulo.getTemporada(), titulo.getEpisodio());
            this.logger.debug("titulo duplicado {}", (Object)encontrados);
        }
        catch (Exception e) {
            this.logger.error("Error {}", (Throwable)e);
            throw new TituloException("Se ha generado un error");
        }
        if (encontrados != null && encontrados > 0) {
            throw new TituloException("El t\u00edtulo ya se encuentra registrado con el mismo Nombre.");
        }
    }

    public void cuentaOcurrenciasEnOtrosContratos(TituloTransaccionDTO t) throws TituloException {
        Integer ocurrences = this.tituloDAO.buscarTitulosOtrosContratosXBV(t.getFechaInicio(), t.getFechaFin(), t.getIdBv(), t.getIdLista());
        if (ocurrences != null && ocurrences != 0) {
            throw new TituloException("El t\u00edtulo ya se encuentra en otro contrato en el mismo id BroadView");
        }
        ocurrences = 0;
        ocurrences = this.tituloDAO.buscarTitulosListaXBV(t.getFechaInicio(), t.getFechaFin(), t.getIdBv(), t.getIdLista(), t.getIdTituloCnt());
        if (ocurrences != null && ocurrences != 0) {
            throw new TituloException("El t\u00edtulo ya se encuentra en la misma lista con el mismo id BroadView");
        }
    }

    public boolean verificarSerieNueva(TituloTransaccionDTO titulo) {
        boolean valido = true;
        if (this.tituloDAO.findCategoriaTrans(titulo.getCategoria()) != 1) {
            valido = false;
        }
        this.logger.debug("serie categoria {}", (Object)valido);
        if (valido && (!TituloTranRules.isNumeric(titulo.getEpisodio()) || Integer.parseInt(titulo.getEpisodio()) < 1)) {
            valido = false;
        }
        this.logger.debug("serie episodio {}", (Object)valido);
        if (valido && (!TituloTranRules.isNumeric(titulo.getTemporada()) || Integer.parseInt(titulo.getTemporada()) < 0)) {
            valido = false;
        }
        this.logger.debug("serie temporada {}", (Object)valido);
        if (valido && this.tituloDAO.findSerieSeasonTrans(titulo.getNombreUnico(), titulo.getTemporada()) > 1) {
            valido = false;
        }
        this.logger.debug("serie existe {}", (Object)valido);
        return valido;
    }

    private static boolean isNumeric(String cadena) {
        try {
            Integer.parseInt(cadena);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

