/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.excelMapper.bos;

import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import java.lang.reflect.Field;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BeanPopulator {
    private Logger logger = LoggerFactory.getLogger((String)"excelMapper");
    private BeanUtilsBean beanUtils;

    @PostConstruct
    public void init() {
        this.beanUtils = BeanUtilsBean.getInstance();
    }

    public <T> T initObject(Class<T> cl) throws ExcelMapperException {
        T object;
        try {
            object = cl.newInstance();
            if (!ClassUtils.isPrimitiveOrWrapper(cl)) {
                Field[] fields;
                for (Field field : fields = FieldUtils.getAllFields(cl)) {
                    this.populate(object, field);
                }
            }
        }
        catch (InstantiationException e) {
            this.logger.error("Managed Error ", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_INIT_POPULATE, new Object[]{e});
        }
        catch (IllegalAccessException e) {
            this.logger.error("Managed Error ", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_INIT_POPULATE, new Object[]{e});
        }
        return object;
    }

    private void populate(Object target, Field field) throws ExcelMapperException {
        Field[] fs;
        if (ClassUtils.isPrimitiveOrWrapper(field.getType()) || field.getType().isArray() || field.getType().isInterface() || String.class == field.getType() || Date.class == field.getType() || field.getType().isEnum()) {
            return;
        }
        Object aux = null;
        try {
            aux = field.getType().newInstance();
        }
        catch (InstantiationException e) {
            throw new ExcelMapperException(ExcelMapperException.ERROR_SETTING_VAL, new Object[]{e});
        }
        catch (IllegalAccessException e) {
            throw new ExcelMapperException(ExcelMapperException.ERROR_SETTING_VAL, new Object[]{e});
        }
        this.setProperty(target, field.getName(), aux);
        for (Field f : fs = FieldUtils.getAllFields(field.getType())) {
            this.populate(aux, f);
        }
    }

    public void setProperty(Object target, String path, Object val) throws ExcelMapperException {
        try {
            this.logger.trace("setting [{}] [{}]", (Object)path, val);
            this.beanUtils.setProperty(target, path, val);
        }
        catch (Exception e) {
            throw new ExcelMapperException((Throwable)e, ExcelMapperException.ERROR_SETTING_VAL, new Object[]{val, path});
        }
    }

    public Object getProperty(Object target, String path) throws ExcelMapperException {
        try {
            return this.beanUtils.getPropertyUtils().getProperty(target, path);
        }
        catch (Exception e) {
            throw new ExcelMapperException((Throwable)e, ExcelMapperException.ERROR_GETTING_VAL, new Object[]{path});
        }
    }

    public void overrideBeanUtilsConfig(BeanUtilsBean bu) {
        if (bu == null) {
            throw new IllegalArgumentException();
        }
        this.beanUtils = bu;
    }
}

