/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.excelMapper.context;

import com.mx.dla.dda.excelMapper.bos.BeanPopulator;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperValidator;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class ExcelMapperContext {
    private Logger logger = LoggerFactory.getLogger((String)"excelMapper");
    private HashMap<String, ExcelMapper> mappers;
    private List<String> locations;
    private String dateFormat;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ExcelMapperValidator validator;
    @Autowired
    private BeanPopulator BeanPopulator;

    @PostConstruct
    public void initIt() throws ExcelMapperException {
        this.logger.debug("loading excel context");
        this.mappers = new HashMap();
        ObjectMapper jsonMapper = new ObjectMapper();
        for (String path : this.locations) {
            try {
                ExcelMapper p = (ExcelMapper)jsonMapper.readValue(this.getInputStreamFile(path), ExcelMapper.class);
                this.validator.validateMapper(p);
                if (p.getId() == null || "".equals(p.getId())) {
                    p.setId(p.getClassName());
                }
                p = this.enrichMapperParent(p);
                this.logger.debug("Adding [{}] file[{}] to excelContext", (Object)p.getId(), (Object)path);
                this.mappers.put(p.getId(), p);
            }
            catch (ExcelMapperException e) {
                this.logger.error("Errores [{}]", (Object)e.getSErrors());
                throw new ExcelMapperException("Error al leer el archivo: " + path, e.getErrors());
            }
            catch (Exception e) {
                this.logger.error("Managed Error ", (Throwable)e);
                throw new ExcelMapperException("Error al leer el archivo: " + path, new Object[]{e});
            }
        }
    }

    private String readFile(String path) throws IOException {
        Resource resource = this.applicationContext.getResource("classpath:" + path);
        StringBuffer sb = new StringBuffer();
        Scanner s = new Scanner(resource.getInputStream());
        while (s.hasNext()) {
            sb.append(s.next());
        }
        return sb.toString();
    }

    private InputStream getInputStreamFile(String path) throws IOException {
        Resource resource = this.applicationContext.getResource("classpath:" + path);
        return resource.getInputStream();
    }

    private ExcelMapper enrichMapperParent(ExcelMapper excelMapper) throws ExcelMapperException {
        ArrayList rules = new ArrayList();
        rules.addAll(0, excelMapper.getRules());
        if (excelMapper.getParent() != null) {
            ExcelMapper p = this.mappers.get(excelMapper.getParent());
            if (p == null) {
                ArrayList<String> errors = new ArrayList<String>();
                errors.add(ExcelMapperException.ERROR_PARENT + excelMapper.getParent());
                throw new ExcelMapperException(ExcelMapperException.ERROR_PARENT + excelMapper.getParent(), errors);
            }
            rules.addAll(0, p.getRules());
        }
        excelMapper.setRules(rules);
        return excelMapper;
    }

    public <T> ExcelMapper getExcelMapper(Class<T> c) {
        this.logger.debug("getmappers {}", c);
        ArrayList<ExcelMapper> ms = new ArrayList<ExcelMapper>(this.mappers.values());
        ArrayList<ExcelMapper> cfg = new ArrayList<ExcelMapper>();
        for (ExcelMapper m : ms) {
            if (!m.getClassName().equals(c.getName())) continue;
            cfg.add(m);
        }
        if (cfg.isEmpty()) {
            throw new IllegalArgumentException("No configuration for " + c.getName());
        }
        if (cfg.size() != 1) {
            throw new IllegalArgumentException(ExcelMapperException.ERROR_MULTIPLE_MAPPER);
        }
        return (ExcelMapper)cfg.get(0);
    }

    public ExcelMapper getExcelMapper(String id) {
        this.logger.debug("getmappers {}", (Object)id);
        ExcelMapper cfg = this.mappers.get(id);
        if (cfg == null) {
            this.logger.error("No se encontro el mapeo con id [{}]", (Object)id);
            throw new IllegalArgumentException("No configuration for " + id);
        }
        return cfg;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void prepareBeanUtils() {
        this.dateFormat = this.dateFormat == null ? "MM/dd/yyyy" : this.dateFormat;
        BeanUtilsBean beanUtils = BeanUtilsBean.getInstance();
        Object defaultValue = null;
        DateConverter converter = new DateConverter(defaultValue);
        converter.setPattern(this.dateFormat);
        beanUtils.getConvertUtils().register((Converter)converter, Date.class);
        this.BeanPopulator.overrideBeanUtilsConfig(beanUtils);
    }

    public BeanPopulator getBeanPopulator() {
        return this.BeanPopulator;
    }
}

