/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.factura.general.bos;

import com.mx.dla.dda.factura.general.bos.FacturacionWServiceBO;
import com.mx.dla.dda.factura.general.daos.FacturacionDAO;
import com.mx.dla.dda.factura.general.dtos.ContratoFacturaDTO;
import com.mx.dla.dda.factura.general.dtos.FacturaGeneralDTO;
import com.mx.dla.dda.factura.general.dtos.MesFacturaDTO;
import com.mx.dla.dda.factura.general.dtos.PagoMesContratoBD;
import com.mx.dla.dda.general.dtos.ResponseDTO;
import com.mx.dla.dda.general.utilerias.ListaUtilerias;
import com.mx.dla.global.bos.BaseBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FacturacionBO
extends BaseBO {
    @Autowired
    private FacturacionDAO facturacionDAO;
    @Autowired
    private FacturacionWServiceBO wsbo;

    public FacturaGeneralDTO cargaFacturaInfoGeneral(Long idFactura) {
        FacturaGeneralDTO facturaGeneral = new FacturaGeneralDTO();
        if (idFactura != null) {
            facturaGeneral.setIdFactura(idFactura);
            facturaGeneral = this.facturacionDAO.consultaFacturaGeneral(facturaGeneral);
        }
        return facturaGeneral;
    }

    public List<ContratoFacturaDTO> cargaFacturaInfoDetalle(Long idEstudio, Long idFactura, Boolean aprovada, String indicadorIva) {
        ArrayList<ContratoFacturaDTO> contratosDetalle = new ArrayList<ContratoFacturaDTO>();
        List contratos = this.facturacionDAO.obtenerContratosEstudio(idEstudio, indicadorIva);
        if (contratos != null && contratos.size() > 0) {
            for (ContratoFacturaDTO contrato : contratos) {
                ContratoFacturaDTO contratoFac = idFactura == null ? this.getContratoMesCostoFacturaNula(contrato, 0L) : this.getContratoMesCosto(contrato, idFactura, aprovada);
                if (contratoFac == null) continue;
                contratosDetalle.add(contratoFac);
            }
        }
        return contratosDetalle;
    }

    public ContratoFacturaDTO getContratoMesCostoFacturaNula(ContratoFacturaDTO contrato, Long idFactura) {
        double totalCto = 0.0;
        double pgdoCto = 0.0;
        double pendienteCto = 0.0;
        double apagarCto = 0.0;
        ArrayList<MesFacturaDTO> costoCto = new ArrayList<MesFacturaDTO>();
        List costosMes = this.facturacionDAO.obtenerCostoMesContrato(contrato.getIdContratoOri());
        List costosPagado = this.facturacionDAO.obtenerPagoMesContrato(contrato.getIdContratoOri(), idFactura);
        for (PagoMesContratoBD costoMes : costosMes) {
            MesFacturaDTO detalle = null;
            for (PagoMesContratoBD costoPgd : costosPagado) {
                if (!this.compareDates(costoMes.getFecha(), costoPgd.getFecha())) continue;
                detalle = this.getMesPago(costoMes, costoPgd, null);
            }
            if (detalle == null) {
                detalle = this.getMesPago(costoMes, null, null);
                detalle.setNuevo(Boolean.valueOf(true));
            }
            boolean sumar = false;
            if (detalle.getTotal() - detalle.getPagado() > 0.0) {
                costoCto.add(detalle);
                sumar = true;
            }
            if (!sumar) continue;
            totalCto += detalle.getTotal().doubleValue();
            pgdoCto += detalle.getPagado().doubleValue();
            pendienteCto += detalle.getPendiente().doubleValue();
            apagarCto += detalle.getPagar().doubleValue();
        }
        contrato.setPagado(Double.valueOf(pgdoCto));
        contrato.setTotal(Double.valueOf(totalCto));
        contrato.setPagar(Double.valueOf(apagarCto));
        contrato.setPendiente(Double.valueOf(pendienteCto));
        contrato.setMeses(costoCto);
        if (contrato.getTotal() - contrato.getPagado() == 0.0) {
            contrato = null;
        }
        return contrato;
    }

    public ContratoFacturaDTO getContratoMesCosto(ContratoFacturaDTO contrato, Long idFactura, Boolean aprovada) {
        double totalCto = 0.0;
        double pgdoCto = 0.0;
        double pendienteCto = 0.0;
        double apagarCto = 0.0;
        ArrayList<MesFacturaDTO> costoCto = new ArrayList<MesFacturaDTO>();
        List costosMes = this.facturacionDAO.obtenerCostoMesContrato(contrato.getIdContratoOri());
        List costosPagado = this.facturacionDAO.obtenerPagoMesContrato(contrato.getIdContratoOri(), idFactura);
        List costosFactura = this.facturacionDAO.obtenerPagoMesFacturaCto(contrato.getIdContratoOri(), idFactura);
        for (PagoMesContratoBD costoMes : costosMes) {
            MesFacturaDTO detalle = null;
            for (PagoMesContratoBD costoFactura : ListaUtilerias.safeList((List)costosFactura)) {
                if (!this.compareDates(costoMes.getFecha(), costoFactura.getFecha())) continue;
                detalle = this.getMesPago(costoMes, this.getMesXFecha(costoMes.getFecha(), costosPagado), costoFactura);
                break;
            }
            if (detalle == null) {
                for (PagoMesContratoBD costoPgd : ListaUtilerias.safeList((List)costosPagado)) {
                    if (!this.compareDates(costoMes.getFecha(), costoPgd.getFecha())) continue;
                    detalle = this.getMesPago(costoMes, costoPgd, this.getMesXFecha(costoMes.getFecha(), costosFactura));
                    break;
                }
            }
            if (detalle == null) {
                detalle = this.getMesPago(costoMes, null, null);
                detalle.setNuevo(Boolean.valueOf(true));
            }
            totalCto += detalle.getTotal().doubleValue();
            pgdoCto += detalle.getPagado().doubleValue();
            pendienteCto += detalle.getPendiente().doubleValue();
            apagarCto += detalle.getPagar().doubleValue();
            costoCto.add(detalle);
        }
        contrato.setPagado(Double.valueOf(pgdoCto));
        contrato.setTotal(Double.valueOf(totalCto));
        contrato.setPagar(Double.valueOf(apagarCto));
        contrato.setPendiente(Double.valueOf(pendienteCto));
        contrato.setMeses(costoCto);
        if (contrato.getPagar() == 0.0 && contrato.getTotal() == 0.0) {
            this.logger.debug(contrato.toString());
            contrato = null;
        }
        return contrato;
    }

    public PagoMesContratoBD getMesXFecha(Date fecha, List<PagoMesContratoBD> costosFactura) {
        PagoMesContratoBD mes = null;
        for (PagoMesContratoBD costoPgd : costosFactura) {
            if (!this.compareDates(costoPgd.getFecha(), fecha)) continue;
            mes = costoPgd;
        }
        return mes;
    }

    public MesFacturaDTO getMesPago(PagoMesContratoBD costo, PagoMesContratoBD pagado, PagoMesContratoBD pagoFacturaMes) {
        double totalMes = 0.0;
        double pgdoMes = 0.0;
        double pendienteMes = 0.0;
        double apagarMes = 0.0;
        totalMes = costo.getMesTotal();
        pgdoMes = pagado != null && pagado.getMesTotal() != null ? pagado.getMesTotal() : 0.0;
        apagarMes = pagoFacturaMes != null && pagoFacturaMes.getMesTotal() != null ? pagoFacturaMes.getMesTotal() : 0.0;
        pendienteMes = totalMes - (pgdoMes + apagarMes);
        MesFacturaDTO detalle = new MesFacturaDTO(null, Double.valueOf(pgdoMes), Double.valueOf(apagarMes), Double.valueOf(pendienteMes), Double.valueOf(totalMes));
        boolean nuevo = pagoFacturaMes == null || pagoFacturaMes.getMesTotal() == null;
        detalle.setNuevo(Boolean.valueOf(nuevo));
        detalle.setMes(this.getFecha(costo.getFecha()));
        detalle.setIdFactura(costo.getIdFactura());
        return detalle;
    }

    public void guardarFactura(FacturaGeneralDTO factura) {
        if (factura.getIdFactura() == null) {
            this.facturacionDAO.creaFacturaGeneral(factura);
        } else {
            this.facturacionDAO.actualizaFacturaGeneral(factura);
        }
        this.guardarFacturaDetalle(factura.getContratos(), factura.getIdFactura());
        this.logger.debug(factura.toString());
    }

    public void guardarFacturaDetalle(List<ContratoFacturaDTO> contratos, Long idFactura) {
        for (ContratoFacturaDTO contrato : contratos) {
            for (MesFacturaDTO mes : ListaUtilerias.safeList((List)contrato.getMeses())) {
                mes.setMes(this.getFecha(mes.getMes()));
                if (mes.getNuevo() != null && mes.getNuevo().booleanValue() && mes.getPagar() > 0.0) {
                    this.logger.debug(idFactura + ":" + contrato.getIdContratoOri() + ":" + mes);
                    this.facturacionDAO.guardarFacturaDetalle(idFactura, contrato.getIdContratoOri(), mes);
                    continue;
                }
                if (mes.getNuevo() == null || mes.getNuevo().booleanValue()) continue;
                this.logger.debug(idFactura + ":" + contrato.getIdContratoOri() + ":" + mes);
                this.facturacionDAO.actualizarFacturaDetalle(idFactura, contrato.getIdContratoOri(), mes);
            }
        }
    }

    public void notificarServicioRest(FacturaGeneralDTO factura) {
        this.logger.debug(factura.toString());
        ResponseDTO respuesta = null;
        if (factura != null) {
            respuesta = this.wsbo.notificaFactura(factura);
        }
        this.logger.debug("Respuesta servicio: {}", (Object)respuesta);
    }

    public FacturaGeneralDTO consultaFactura(Long idFactura) {
        FacturaGeneralDTO factura = new FacturaGeneralDTO();
        factura.setIdFactura(idFactura);
        return this.facturacionDAO.consultaFacturaGeneral(factura);
    }

    public String getFecha(Date fecha) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        return sdf.format(fecha);
    }

    public String getFecha(String fecha) {
        String[] meses = fecha.split("/");
        return meses[1] + "-" + meses[0] + "-" + meses[2];
    }

    public boolean compareDates(Date uno, Date dos) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(uno);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(dos);
        return cal1.equals(cal2);
    }
}

