/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.ncredito.general.bos;

import com.mx.dla.dda.general.utilerias.ListaUtilerias;
import com.mx.dla.dda.general.utilerias.StringUtilerias;
import com.mx.dla.dda.ncredito.general.bos.NotaCreditoWServiceBO;
import com.mx.dla.dda.ncredito.general.daos.NotaCreditoDAO;
import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoDetalleDTO;
import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoGeneralDTO;
import com.mx.dla.dda.ncredito.general.dtos.ContratoTitulo;
import com.mx.dla.dda.ncredito.general.dtos.NotaCredito;
import com.mx.dla.dda.ncredito.general.dtos.NotaCreditoDetalle;
import com.mx.dla.dda.ncredito.general.dtos.TituloNotaCreditoDTO;
import com.mx.dla.global.bos.BaseBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotaCreditoBO
extends BaseBO {
    @Autowired
    private NotaCreditoDAO notaCreditoDAO;
    @Autowired
    private NotaCreditoWServiceBO wsbo;

    public ContratoNotaCreditoGeneralDTO cargaNotaCreditoGeneral(Long idEstudio, Long idNota) {
        NotaCredito notaCredito = null;
        LinkedList lnotasCredito = null;
        ArrayList<Long> estudios = null;
        List notasCredito = new ArrayList();
        ContratoNotaCreditoGeneralDTO notaGeneral = new ContratoNotaCreditoGeneralDTO();
        if (idEstudio != null) {
            estudios = new ArrayList<Long>(Arrays.asList(idEstudio));
        }
        if (idNota != null && estudios == null || estudios != null && idNota == null) {
            notasCredito = ListaUtilerias.safeList((List)this.notaCreditoDAO.consultaNotaCreditoGeneral(idNota, estudios, null));
        }
        if (!(lnotasCredito = new LinkedList(notasCredito)).isEmpty()) {
            notaCredito = (NotaCredito)lnotasCredito.getFirst();
            notaGeneral.setApproved(notaCredito.getApproved());
            notaGeneral.setComentario(notaCredito.getComentario());
            notaGeneral.setFechaFactura(notaCredito.getFecha());
            notaGeneral.setIdEstudio(notaCredito.getIdEstudio());
            notaGeneral.setIdNota(notaCredito.getIdNota());
            notaGeneral.setIdSapRegistro(notaCredito.getIdSapRegistro());
            notaGeneral.setNumeroFactura(notaCredito.getNoFactura());
        }
        return notaGeneral;
    }

    @Deprecated
    public List<ContratoNotaCreditoDetalleDTO> cargaNotaCreditoDetalles(Long idEstudio, Long idNota, Boolean aprovada) {
        Object valorMonto;
        List dbtitulos = null;
        List udbtitulos = null;
        List notaCreditoDetalle = null;
        ArrayList<ContratoNotaCreditoDetalleDTO> contratos = new ArrayList<ContratoNotaCreditoDetalleDTO>();
        ArrayList<TituloNotaCreditoDTO> titulos = new ArrayList<TituloNotaCreditoDTO>();
        LinkedList lcontratosTitulos = null;
        LinkedList lnotaCreditoDetalle = null;
        ContratoTitulo primerTitulo = null;
        Long idContrato = null;
        Long idTituloCnt = null;
        Double costoTotal = null;
        Double costoTotalActual = 0.0;
        String noContrato = null;
        String noContratoActual = null;
        String idSap = null;
        String idSapActual = null;
        String claveIva = null;
        String claveIvaActual = null;
        Double montoTotal = 0.0;
        Double montoTotalActual = 0.0;
        Double monto = 0.0;
        Double costo = 0.0;
        Double montoContrato = 0.0;
        Double costoContrato = 0.0;
        dbtitulos = ListaUtilerias.safeList((List)this.notaCreditoDAO.consultaTitulosBajaDisponibles(idEstudio));
        udbtitulos = ListaUtilerias.safeList((List)this.notaCreditoDAO.consultaTitulosBajaUtilizados(idEstudio, Long.valueOf(idNota == null ? 0L : idNota)));
        dbtitulos = (ArrayList)CollectionUtils.subtract((Collection)dbtitulos, (Collection)udbtitulos);
        lcontratosTitulos = new LinkedList(dbtitulos);
        primerTitulo = (ContratoTitulo)lcontratosTitulos.getFirst();
        idContrato = primerTitulo.getIdContrato();
        idSap = primerTitulo.getIdSap();
        noContrato = primerTitulo.getNumeroContrato();
        claveIva = primerTitulo.getClaveIva();
        idTituloCnt = primerTitulo.getIdTituloCnt();
        costoTotal = new Double(primerTitulo.getCosto());
        notaCreditoDetalle = ListaUtilerias.safeList((List)this.notaCreditoDAO.consultaNotaCreditoDetalle(null, Long.valueOf(idNota == null ? 0L : idNota), idContrato, idTituloCnt));
        lnotaCreditoDetalle = new LinkedList(notaCreditoDetalle);
        if (!lnotaCreditoDetalle.isEmpty() && (valorMonto = ((NotaCreditoDetalle)lnotaCreditoDetalle.getFirst()).getMonto()) != null && StringUtilerias.isFloat((String)valorMonto)) {
            montoTotal = new Double((String)valorMonto);
        }
        for (ContratoTitulo contratoTitulo : dbtitulos) {
            String valorMonto2;
            String descTitulo = contratoTitulo.getDescTitulo();
            Long idTituloCntActual = contratoTitulo.getIdTituloCnt();
            Long idContratoActual = contratoTitulo.getIdContrato();
            Boolean nuevo = true;
            noContratoActual = contratoTitulo.getNumeroContrato();
            idSapActual = contratoTitulo.getIdSap();
            claveIvaActual = contratoTitulo.getClaveIva();
            costo = new Double(contratoTitulo.getCosto());
            notaCreditoDetalle = ListaUtilerias.safeList((List)this.notaCreditoDAO.consultaNotaCreditoDetalle(null, Long.valueOf(idNota == null ? 0L : idNota), idContratoActual, idTituloCntActual));
            lnotaCreditoDetalle = new LinkedList(notaCreditoDetalle);
            TituloNotaCreditoDTO titulo = new TituloNotaCreditoDTO();
            titulo.setCosto(costo.toString());
            titulo.setDescTitulo(descTitulo);
            titulo.setIdTituloCnt(idTituloCntActual);
            titulo.setTipoTitulo(Integer.valueOf(0));
            if (!lnotaCreditoDetalle.isEmpty() && (valorMonto2 = ((NotaCreditoDetalle)lnotaCreditoDetalle.getFirst()).getMonto()) != null) {
                if (StringUtilerias.isFloat((String)valorMonto2)) {
                    monto = new Double(valorMonto2);
                }
                nuevo = false;
            }
            titulo.setNuevo(nuevo);
            titulo.setMonto(monto.toString());
            costoTotal = costoTotalActual;
            costoTotalActual = costoTotalActual + costo;
            montoTotal = montoTotalActual;
            montoTotalActual = montoTotalActual + monto;
            if (idContrato != idContratoActual) {
                ContratoNotaCreditoDetalleDTO contrato = new ContratoNotaCreditoDetalleDTO();
                contrato.setIdContrato(idContrato);
                contrato.setNumeroContrato(noContrato);
                contrato.setClaveIva(claveIva);
                contrato.setIdSap(idSap);
                contratos.add(contrato);
                List<TituloNotaCreditoDTO> dbtitulosdisminucion = this.titulosNotaCreditoDisminucion(idNota, idContrato);
                for (TituloNotaCreditoDTO dbtitulodisminucion : dbtitulosdisminucion) {
                    costoTotal = costoTotal + new Double(dbtitulodisminucion.getCosto());
                    montoTotal = montoTotal + new Double(dbtitulodisminucion.getMonto());
                }
                contrato.setCosto(costoTotal.toString());
                contrato.setMonto(montoTotal.toString());
                titulos.addAll(dbtitulosdisminucion);
                contrato.setTitulos(titulos);
                titulos = new ArrayList();
                idContrato = idContratoActual;
                noContrato = noContratoActual;
                claveIva = claveIvaActual;
                idSap = idSapActual;
                costoTotalActual = costo;
                montoTotalActual = monto;
                montoContrato = montoContrato + montoTotal;
                costoContrato = costoContrato + costoTotal;
            }
            titulos.add(titulo);
            monto = 0.0;
        }
        costoTotal = costoTotalActual;
        montoTotal = montoTotalActual;
        montoContrato = montoContrato + montoTotal;
        costoContrato = costoContrato + costoTotal;
        ContratoNotaCreditoDetalleDTO contrato = new ContratoNotaCreditoDetalleDTO();
        contrato.setIdContrato(idContrato);
        contrato.setNumeroContrato(noContrato);
        contrato.setClaveIva(claveIva);
        contrato.setIdSap(idSap);
        List<TituloNotaCreditoDTO> dbtitulosdisminucion = this.titulosNotaCreditoDisminucion(idNota, idContrato);
        for (TituloNotaCreditoDTO dbtitulodisminucion : dbtitulosdisminucion) {
            costoTotal = costoTotal + new Double(dbtitulodisminucion.getCosto());
            montoTotal = montoTotal + new Double(dbtitulodisminucion.getMonto());
        }
        contrato.setCosto(costoTotal.toString());
        contrato.setMonto(montoTotal.toString());
        titulos.addAll(dbtitulosdisminucion);
        contrato.setTitulos(titulos);
        contratos.add(contrato);
        return contratos;
    }

    @Deprecated
    List<TituloNotaCreditoDTO> titulosNotaCreditoDisminucion(Long idNota, Long idContrato) {
        List dbtitulos = ListaUtilerias.safeList((List)this.notaCreditoDAO.consultaTitulosDisminucionDisponibles(idContrato));
        List udbtitulos = ListaUtilerias.safeList((List)this.notaCreditoDAO.consultaTitulosDisminucionUtilizados(idContrato, Long.valueOf(idNota == null ? 0L : idNota)));
        dbtitulos = (ArrayList)CollectionUtils.subtract((Collection)dbtitulos, (Collection)udbtitulos);
        ArrayList<TituloNotaCreditoDTO> titulos = new ArrayList<TituloNotaCreditoDTO>();
        Double monto = 0.0;
        Boolean nuevo = true;
        for (ContratoTitulo dbtitulo : dbtitulos) {
            String valorMonto;
            TituloNotaCreditoDTO titulo = new TituloNotaCreditoDTO();
            titulo.setCosto(dbtitulo.getCosto().toString());
            titulo.setDescTitulo(dbtitulo.getDescTitulo());
            titulo.setIdTituloCnt(dbtitulo.getIdTituloCnt());
            titulo.setTipoTitulo(Integer.valueOf(1));
            List notaCreditoDetalle = ListaUtilerias.safeList((List)this.notaCreditoDAO.consultaNotaCreditoDetalle(null, Long.valueOf(idNota == null ? 0L : idNota), idContrato, dbtitulo.getIdTituloCnt()));
            LinkedList lnotaCreditoDetalle = new LinkedList(notaCreditoDetalle);
            if (!lnotaCreditoDetalle.isEmpty() && (valorMonto = ((NotaCreditoDetalle)lnotaCreditoDetalle.getFirst()).getMonto()) != null) {
                if (StringUtilerias.isFloat((String)valorMonto)) {
                    monto = new Double(valorMonto);
                }
                nuevo = false;
            }
            titulo.setMonto(monto.toString());
            titulo.setNuevo(nuevo);
            titulos.add(titulo);
            monto = 0.0;
        }
        return titulos;
    }

    public List<ContratoNotaCreditoDetalleDTO> cargaNotaCreditoDetalle(Long idEstudio, Long idNotaCredito, Boolean aprovada) {
        List bcontratos = null;
        List dcontratos = null;
        List bctitulos = null;
        List dctitulos = null;
        List bntitulos = null;
        List dntitulos = null;
        List bnntitulos = null;
        List dnntitulos = null;
        Long idNota = 0L;
        if (idNotaCredito != null) {
            idNota = new Long(idNotaCredito);
        }
        ArrayList<ContratoNotaCreditoDetalleDTO> contratoNotaDetalle = new ArrayList<ContratoNotaCreditoDetalleDTO>();
        bcontratos = this.notaCreditoDAO.obtenContratosConBaja(idEstudio);
        dcontratos = this.notaCreditoDAO.obtenContratosConDisminucion(idEstudio);
        List<Object> contratos = new ArrayList();
        contratos = this.mergeList(bcontratos, dcontratos);
        for (ContratoTitulo contrato : ListaUtilerias.safeList(contratos)) {
            Long idContrato = contrato.getIdContrato();
            bctitulos = ListaUtilerias.safeList((List)this.notaCreditoDAO.obtenTitulosBajaPorContrato(idEstudio, idContrato));
            dctitulos = ListaUtilerias.safeList((List)this.notaCreditoDAO.obtenTitulosDisminucionPorContrato(idEstudio, idContrato));
            bntitulos = ListaUtilerias.safeList((List)this.notaCreditoDAO.obtenTitulosBajaPorContratoEnNota(idEstudio, idContrato, idNota));
            dntitulos = ListaUtilerias.safeList((List)this.notaCreditoDAO.obtenTitulosDisminucionPorContratoEnNota(idEstudio, idContrato, idNota));
            bnntitulos = ListaUtilerias.safeList((List)this.notaCreditoDAO.obtenTitulosBajaPorContratoNoEnNota(idEstudio, idContrato, idNota));
            dnntitulos = ListaUtilerias.safeList((List)this.notaCreditoDAO.obtenTitulosDisminucionPorContratoNoEnNota(idEstudio, idContrato, idNota));
            List mbtitulos = ListaUtilerias.safeList(this.mergeList(bntitulos, bctitulos));
            List mdtitulos = ListaUtilerias.safeList(this.mergeList(dntitulos, dctitulos));
            List btitulos = (List)CollectionUtils.subtract((Collection)mbtitulos, (Collection)bnntitulos);
            List dtitulos = (List)CollectionUtils.subtract((Collection)mdtitulos, (Collection)dnntitulos);
            Double costo = 0.0;
            Double monto = 0.0;
            ArrayList<TituloNotaCreditoDTO> titulos = new ArrayList<TituloNotaCreditoDTO>();
            List<TituloNotaCreditoDTO> vbtitulos = this.transformTitulo(btitulos);
            List<TituloNotaCreditoDTO> vdtitulos = this.transformTitulo(dtitulos);
            titulos.addAll(vbtitulos);
            titulos.addAll(vdtitulos);
            for (TituloNotaCreditoDTO titulo : ListaUtilerias.safeList(titulos)) {
                String scosto = titulo.getCosto();
                Double tcosto = 0.0;
                String smonto = titulo.getMonto();
                Double tmonto = 0.0;
                if (scosto != null) {
                    tcosto = new Double(scosto);
                }
                if (smonto != null) {
                    tmonto = new Double(smonto);
                }
                costo = costo + tcosto;
                monto = monto + tmonto;
            }
            ContratoNotaCreditoDetalleDTO fcontrato = new ContratoNotaCreditoDetalleDTO();
            fcontrato.setIdContrato(idContrato);
            fcontrato.setNumeroContrato(contrato.getNumeroContrato());
            fcontrato.setClaveIva(contrato.getClaveIva());
            fcontrato.setIdSap(contrato.getIdSap());
            fcontrato.setCosto(costo.toString());
            fcontrato.setMonto(monto.toString());
            fcontrato.setTitulos(titulos);
            if (titulos == null || titulos.size() <= 0) continue;
            contratoNotaDetalle.add(fcontrato);
        }
        return contratoNotaDetalle;
    }

    public TituloNotaCreditoDTO transformTitulo(ContratoTitulo titulo) {
        Double costo = 0.0;
        Double monto = 0.0;
        if (titulo.getCosto() != null) {
            costo = new Double(titulo.getCosto());
        }
        if (titulo.getMonto() != null) {
            monto = new Double(titulo.getMonto());
        }
        TituloNotaCreditoDTO vtitulo = new TituloNotaCreditoDTO();
        vtitulo.setCosto(costo.toString());
        vtitulo.setDescTitulo(titulo.getDescTitulo());
        vtitulo.setIdTituloCnt(titulo.getIdTituloCnt());
        vtitulo.setMonto(monto.toString());
        vtitulo.setTipoTitulo(titulo.getTipoTitulo());
        return vtitulo;
    }

    public List<TituloNotaCreditoDTO> transformTitulo(List<ContratoTitulo> titulos) {
        ArrayList<TituloNotaCreditoDTO> vtitulos = new ArrayList<TituloNotaCreditoDTO>();
        for (ContratoTitulo titulo : titulos) {
            TituloNotaCreditoDTO vbtitulo = this.transformTitulo(titulo);
            vtitulos.add(vbtitulo);
        }
        return vtitulos;
    }

    public <T> List<T> mergeList(List<T> target, List<T> other) {
        HashSet<T> scontratos = new HashSet<T>(target);
        scontratos.addAll(other);
        ArrayList<T> result = new ArrayList<T>(scontratos);
        return result;
    }

    public Long guardarFactura(ContratoNotaCreditoGeneralDTO factura) {
        Long idNota = factura.getIdNota();
        NotaCredito notaCredito = new NotaCredito();
        notaCredito.setApproved(factura.getApproved());
        notaCredito.setComentario(factura.getComentario());
        notaCredito.setFecha(factura.getFechaFactura());
        notaCredito.setIdEstudio(factura.getIdEstudio());
        notaCredito.setIdNota(factura.getIdNota());
        notaCredito.setIdSapRegistro(factura.getIdSapRegistro());
        notaCredito.setNoFactura(factura.getNumeroFactura());
        if (idNota == null) {
            idNota = this.notaCreditoDAO.guardarNotaCredito(notaCredito);
            idNota = notaCredito.getIdNota();
        } else {
            this.notaCreditoDAO.actualizarNotaCredito(notaCredito);
        }
        this.guardarFacturaDetalle(factura.getContratos(), notaCredito.getIdNota());
        return idNota;
    }

    public void guardarFacturaDetalle(List<ContratoNotaCreditoDetalleDTO> contratos, Long idNota) {
        NotaCreditoDetalle detalle = null;
        for (ContratoNotaCreditoDetalleDTO contrato : ListaUtilerias.safeList(contratos)) {
            for (TituloNotaCreditoDTO titulo : ListaUtilerias.safeList((List)contrato.getTitulos())) {
                Long idContrato = contrato.getIdContrato();
                Long idTitulo = titulo.getIdTituloCnt();
                String monto = titulo.getMonto();
                List detalles = this.notaCreditoDAO.consultaNotaCreditoDetalle(null, idNota, idContrato, idTitulo);
                if (detalles.isEmpty()) {
                    detalle = new NotaCreditoDetalle();
                    detalle.setIdContrato(idContrato);
                    detalle.setIdNota(idNota);
                    detalle.setIdTituloCnt(idTitulo);
                    detalle.setMonto(monto);
                    this.notaCreditoDAO.guardarNotaCreditoDetalle(detalle);
                    continue;
                }
                LinkedList ldetalles = new LinkedList(detalles);
                detalle = (NotaCreditoDetalle)ldetalles.getFirst();
                detalle.setMonto(monto);
                this.notaCreditoDAO.actualizarNotaCreditoDetalle(detalle);
            }
        }
    }

    public void notificarServicioRest(ContratoNotaCreditoGeneralDTO factura) {
        if (factura != null && factura.getApproved() == 1) {
            int estatus = this.wsbo.notificaFacturaInterfaz(factura);
            this.logger.debug("Actualiza a factura notificada");
        }
    }

    public String getFecha(Date fecha) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        return sdf.format(fecha);
    }

    public String getFecha(String fecha) {
        String[] meses = fecha.split("/");
        return meses[1] + "-" + meses[0] + "-" + meses[2];
    }

    public boolean compareDates(Date uno, Date dos) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(uno);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(dos);
        return cal1.equals(cal2);
    }
}

