/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reportes.generaxml;

import com.mx.dla.dda.reporte.general.dtos.ExcelEstilosConfDTO;
import com.mx.dla.global.bos.BaseBO;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExcelXmlConfiguracionWriter
extends BaseBO {
    @Value(value="${excel.process.source.path}")
    private String fileRoute;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToXml(String fileName, List<LinkedHashMap<String, Object>> header, List<LinkedHashMap<String, Object>> tabla, List<ExcelEstilosConfDTO> estilos, String tituloReporte) throws IOException, XMLStreamException {
        Path path = Paths.get(this.fileRoute + "/" + fileName, new String[0]);
        this.logger.info(this.fileRoute + "/" + fileName);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            try (XMLStreamWriter writer = null;){
                writer = outputFactory.createXMLStreamWriter(os, "utf-8");
                this.createXml(writer, header, tabla, estilos, tituloReporte);
            }
        }
    }

    private void createXml(XMLStreamWriter writer, List<LinkedHashMap<String, Object>> header, List<LinkedHashMap<String, Object>> tabla, List<ExcelEstilosConfDTO> estilos, String tituloReporte) throws XMLStreamException {
        writer.writeStartDocument("utf-8", "1.0");
        writer.writeComment("Se crea configuracion para archivo xls");
        writer.writeStartElement("Archivo");
        writer.writeStartElement("Tabla");
        writer.writeAttribute("id", "Hoja 1");
        this.tiuloRow(writer, tituloReporte);
        this.logger.info("Empieza creacion");
        this.logger.info("{}", estilos);
        ArrayList<LinkedHashMap<String, Object>> reporte = new ArrayList<LinkedHashMap<String, Object>>(header);
        reporte.addAll(tabla);
        long x = 0L;
        for (LinkedHashMap linkedHashMap : reporte) {
            writer.writeStartElement("Fila");
            writer.writeAttribute("id", "");
            writer.writeAttribute("visible", "true");
            long y = 0L;
            for (Map.Entry column : linkedHashMap.entrySet()) {
                ExcelEstilosConfDTO aplica = null;
                this.logger.info("{}", column);
                this.logger.info("{} {}", (Object)x, (Object)y);
                for (ExcelEstilosConfDTO estilo : estilos) {
                    if (!estilo.find(Long.valueOf(x), Long.valueOf(y)).booleanValue()) continue;
                    aplica = estilo;
                    break;
                }
                this.logger.info("{}", aplica);
                aplica.setText(column.getValue() == null ? null : column.getValue().toString());
                this.logger.info("{}", (Object)aplica.getText());
                writer.writeStartElement("Celda");
                writer.writeStartElement("width");
                writer.writeCharacters(aplica.getWidth());
                writer.writeEndElement();
                writer.writeStartElement("height");
                writer.writeCharacters(aplica.getHeight());
                writer.writeEndElement();
                writer.writeStartElement("colspan");
                writer.writeCharacters(aplica.getColspan());
                writer.writeEndElement();
                writer.writeStartElement("rowspan");
                writer.writeCharacters(aplica.getRowspan());
                writer.writeEndElement();
                writer.writeStartElement("align");
                writer.writeCharacters(aplica.getAlign());
                writer.writeEndElement();
                writer.writeStartElement("valign");
                writer.writeCharacters(aplica.getValign());
                writer.writeEndElement();
                writer.writeStartElement("cellClass");
                writer.writeCharacters(aplica.getCellClass());
                writer.writeEndElement();
                writer.writeStartElement("value");
                writer.writeCharacters(aplica.getValue());
                writer.writeEndElement();
                writer.writeStartElement("text");
                writer.writeCharacters(aplica.getText());
                writer.writeEndElement();
                writer.writeStartElement("datatype");
                writer.writeCharacters(aplica.getDatatype());
                writer.writeEndElement();
                writer.writeEndElement();
                ++y;
            }
            writer.writeEndElement();
            ++x;
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        this.logger.info("Acaba creacion");
    }

    private void tiuloRow(XMLStreamWriter writer, String titulo) throws XMLStreamException {
        writer.writeStartElement("Fila");
        writer.writeAttribute("id", "");
        writer.writeAttribute("visible", "true");
        writer.writeStartElement("Celda");
        writer.writeStartElement("width");
        writer.writeCharacters(null);
        writer.writeEndElement();
        writer.writeStartElement("height");
        writer.writeCharacters(String.valueOf(0));
        writer.writeEndElement();
        writer.writeStartElement("colspan");
        writer.writeCharacters(String.valueOf(13));
        writer.writeEndElement();
        writer.writeStartElement("rowspan");
        writer.writeCharacters(String.valueOf(1));
        writer.writeEndElement();
        writer.writeStartElement("align");
        writer.writeCharacters("center");
        writer.writeEndElement();
        writer.writeStartElement("valign");
        writer.writeCharacters("middle");
        writer.writeEndElement();
        writer.writeStartElement("cellClass");
        writer.writeCharacters("titulo_modulo");
        writer.writeEndElement();
        writer.writeStartElement("value");
        writer.writeCharacters(titulo);
        writer.writeEndElement();
        writer.writeStartElement("text");
        writer.writeCharacters(titulo);
        writer.writeEndElement();
        writer.writeStartElement("datatype");
        writer.writeCharacters("string");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

