<!DOCTYPE html>
<%@ page language="java" contentType="text/html; charset=iso-8859-1"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="/WEB-INF/struts-tags.tld" prefix="s"%>
<%@ taglib uri="http://www.springframework.org/security/tags" prefix="sec"%>

<c:set var="contextPath" value="${pageContext.request.contextPath}"	scope="request" />
<html lang="es">
<head>
	<title>DLA - Derechos de Autor</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="">
	<!-- ===== FAVICON =====-->
	<link rel="shortcut icon" href="${contextPath}/design/favicon.ico">
	<!-- ===== CSS =====-->
	<!-- General-->
	<link rel="stylesheet" href="${contextPath}/design/css/basic.css">
	<link rel="stylesheet" href="${contextPath}/design/css/general.css">
	<link rel="stylesheet" href="${contextPath}/design/css/theme.css" class="style-theme">

	<!--[if lt IE 9]>
    <script src="${contextPath}/design/js/basic/respond.min.js"></script>
    <script src="${contextPath}/design/js/basic/html5shiv.min.js"></script>
    <![endif]-->
</head>
<body class="login-bg">

	<!--[if lt IE 9]>
    <p class="browsehappy">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->

	<!--SECTION-->
	<section class="l-main-container">
		<!--Main Content-->
		<div class="login-wrapper">
			<div class="login-container">
				<!--Logo-->
				<h1 class="login-logo">
					<img src="${contextPath}/design/img/logo.png" alt='<fmt:message key="gral.home.title" />'>
				</h1>				
				<!--Login Form-->				
				<form id="loginForm" action="<c:url value='j_spring_security_check'/>" method="post" 
						role="form" class="login-form">					
					<div class="form-group">
						<c:if test="${param.login_error eq 1}">
							<label class="error">
								Usuario y/o contrase&ntilde;a no vlidos.
							</label>
						</c:if>
					</div>				
					<div class="form-group">
						<input id="loginEmail" type="text" name="j_username"
							placeholder='Usuario' class="form-control">
					</div>
					<div class="form-group">
						<input id="loginPassword" type="password" name="j_password"
							placeholder='Contrasea' class="form-control">
					</div>
					<button style="text-align: center !important;" type="submit"
						class="btn btn-login-red btn-block btn-login">Ingresar</button>
					<div class="login-options">
						<!-- <a href="#"><fmt:message key="gral.login.olvidoPwd" /></a>  -->
					</div>
				</form>
			</div>
		</div>
	</section>
	<!-- ===== JS =====-->
	<!-- jQuery-->
	<script src="${contextPath}/design/js/basic/jquery.min.js"></script>
	<script src="${contextPath}/design/js/basic/jquery-migrate.min.js"></script>
	<!-- General-->
	<script src="${contextPath}/design/js/basic/modernizr.min.js"></script>
	<script src="${contextPath}/design/js/basic/bootstrap.min.js"></script>
	<script src="${contextPath}/design/js/shared/jquery.asonWidget.js"></script>
	<script src="${contextPath}/design/js/plugins/plugins.js"></script>
	<script src="${contextPath}/design/js/general.js"></script>
	<!-- Semi general-->
	<!-- <script type="text/javascript">
      var paceSemiGeneral = { restartOnPushState: false };
      if (typeof paceSpecific != 'undefined'){
      	var paceOptions = $.extend( {}, paceSemiGeneral, paceSpecific );
      	paceOptions = paceOptions;
      }else{
      	paceOptions = paceSemiGeneral;
      }
      
    </script> -->
    <!-- 
	<script src="${contextPath}/design/js/plugins/pageprogressbar/pace.min.js"></script>
	 -->
	 
	<!-- Specific-->
	<script src="${contextPath}/design/js/plugins/forms/validation/jquery.validate.min.js"></script>
	<script
		src="${contextPath}/design/js/plugins/forms/validation/jquery.validate.additional.min.js"></script>
	<script src="${contextPath}/design/js/calls/page.login.js"></script>
	
	<script>
		var gstError_003 = '<fmt:message key="error.003"/>';
		var gstError_004 = '<fmt:message key="error.004"/>';
		
	</script>
	
</body>
</html>

<%--

<script>
	function fValidarForma(pobForma) {
		var login = pobForma.j_username.value;
		var pass = pobForma.j_password.value;

		if (login.length == 0) {
			$('#pMensajeError').html('<fmt:message key="error.003"/>');
		} else if (pass.length == 0) {
			$('#pMensajeError').html('<fmt:message key="error.004"/>');
		} else {
			var cadSinEsp = /[^A-Za-z0-9$]/;
			var errorMessage = '<fmt:message key="error.005"/>: ';

			if (cadSinEsp.test(login)) {
				$('#pMensajeError')
						.html(
								errorMessage
										+ '\"<fmt:message key="gral.login.usuario"/>\"');
			} else if (cadSinEsp.test(pass)) {
				$('#pMensajeError')
						.html(
								errorMessage
										+ '\"<fmt:message key="gral.login.password"/>\"');
			} else {
				pobForma.submit();
			}
		}

		return false;
	}
</script>

<form action="<c:url value='j_spring_security_check'/>" method="post"
		onSubmit="return fValidarForma(document.forms[0])">
	<table class="tbLogin">
		<tr>
			<td class="clInputLabel"><fmt:message key="gral.login.usuario" />:</td>
			<td class="clInputElement"><input class="login" type="text"
				name="j_username" /></td>
		</tr>
		<tr>
			<td class="clInputLabel"><fmt:message key="gral.login.password" />:</td>
			<td class="clInputElement"><input class="login" type="password"
				name="j_password" />
		</tr>
		<tr>
			<td colspan="2" align="center" height="30"><input
				class="clButtonActive" type="submit"
				value='<fmt:message key="gral.login.ingresar"/>' /></td>
		</tr>
		<tr>
			<td>
				<div id="msg_error">
					<p id="pMensajeError">
						<c:if test="${param.login_error eq 1}">
							<fmt:message key="error.001" />
						</c:if>
					</p>
				</div>
			</td>
		</tr>
	</table>
</form>
<%@include file="/jsp/common/defaultBottom.jsp"%>

 --%>