package com.mx.dla.dda.admin.catalogos.addons.actions;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.addons.bos.EstudioAddonBO;
import com.mx.dla.dda.admin.catalogos.addons.bos.ReporteAddOnsBO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.ReporteAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.bos.EstudioBO;
import com.mx.dla.global.actions.BaseAction;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class EstudiosAddOnAction extends BaseAction{
	
	private static final long serialVersionUID = 1L;
	private List<EstudioAddonDTO> estudios;
	private List<ReporteAddonDTO> reportes;
	private EstudioAddonDTO estudio;
	private Long idEstudio;
	private String nombreEstudio;
	private String adon;
	private String redClientes;
	private String reporte;
	private String agrupado;
	private Boolean ok;
	
	private boolean estudioActualizado;
	
	@Autowired
	private EstudioAddonBO estudioAddonBO;
	
	@Autowired
	private ReporteAddOnsBO reporteAddOnsBO;
	
	@Autowired
	private EstudioBO estudioBO;

	@Override
	public String execute() throws Exception {
		return SUCCESS;
	}
	
	public String listadoEstudiosAddons() {
		setEstudios(estudioAddonBO.getEstudios());
		return SUCCESS;
	}
	
	public String dirigirAgregarEstudio() throws Exception {
		setReportes(reporteAddOnsBO.getTiposReporte(StringUtils.EMPTY));
		setPmns();
		return SUCCESS;
	}
	
	public String guardaEstudio() {
		EstudioAddonDTO addon = new EstudioAddonDTO();
		addon.setNombre(nombreEstudio);
		addon.setIdReporte(reporte);
		addon.setReduClientes(redClientes);
		addon.setAddon(adon);
		addon.setDecimales("2");
		addon.setAgrupado(agrupado == null ? "0":agrupado);
		estudioAddonBO.guardarAddon(addon);
		setPmns();
		return SUCCESS;
	}
	
	public String obtnenAddon() {
		setEstudio(estudioAddonBO.getEstudioById(idEstudio));
		setReportes(reporteAddOnsBO.getTiposReporte(StringUtils.EMPTY));
		setPmns();
		return SUCCESS;
	}
	
	public String actualizaAddonMod() {
		System.out.println("*************Agrupado*********" + agrupado);
		EstudioAddonDTO addon = new EstudioAddonDTO();
		addon.setIdEstudio(idEstudio.intValue());
		addon.setNombre(nombreEstudio);
		addon.setIdReporte(reporte);
		addon.setReduClientes(redClientes);
		addon.setAddon(adon);
		addon.setDecimales("2");
		addon.setAgrupado(agrupado == null ? "0":agrupado);
		ok = estudioAddonBO.modificaAddon(addon);
		return SUCCESS;
	}
	
	public void setPmns(){		
		logger.debug("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 210);
		this.getSession().put("pmnReturn", 210);
		this.setPmn("210");
		this.setPmnReturn("210");
	}

}
