package com.mx.dla.dda.admin.catalogos.apartados.actions;

import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.apartados.bos.ApartadosBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.excepcion.SuscriptorException;
import com.mx.dla.dda.contrato.generales.dtos.ApartadoDTO;

public class ApartadosAction extends BaseContratoAction{

	private static final long serialVersionUID = 6539076129813362003L;

	private List<ApartadoDTO> apartados;
	private String            descripcion;	
	private String            idApartado;
	private String            amortizable;
	private String            mensaje;	
	
	@Autowired
	private ApartadosBO apartadosBO;
		
	public String CatalogoApartados(){	
		try {
			
			this.apartados = apartadosBO.selectBusquedaApartados(amortizable);
			
		}catch(PersistenceException  ibe){
			   this.mensaje = "Ocurri un error al obtener los datos.";
			   logger.error("Error.", ibe);			   			  
		}catch(Exception e){
			   this.mensaje = "Ocurri un error al obtener los datos.";
			   logger.error("Error.", e);			   
		}							
		return "listado";
	}
	
	public String generarApartado(){
		
		try {									
			logger.debug(""+this.descripcion+":"+ this.idApartado +":"+this.amortizable);
			this.mensaje = apartadosBO.generarApartado(this.descripcion, this.idApartado, this.amortizable);
			if(this.mensaje != null)
				this.idApartado = this.mensaje;
			
		}catch(SuscriptorException  se){
			   this.mensaje = se.getMessage();
			   this.idApartado = null;			   					
		}catch(PersistenceException  ibe){
			   this.mensaje = "Ocurri un error al obtener los datos.";
			   this.idApartado = null;
			   logger.error("Error.", ibe);			   			   
		}catch(Exception e){
			   this.mensaje = "Ocurri un error al obtener los datos.";
			   this.idApartado = null;
			   logger.error("Error.", e);			   
		}		
		return "listado";
	}
	
	public String notificarSAP(){
		
		try {									
			logger.debug(""+this.descripcion+":"+ this.idApartado +":"+this.amortizable);
			
			ApartadoDTO apartado = new ApartadoDTO(Long.parseLong(this.idApartado), this.descripcion);
			
			logger.debug(apartado.toString());
			apartadosBO.notificarApartadoNoAmortizablesSAP(apartado);
			
			this.idApartado = apartado.getIdSap() != null || apartado.getIdSap().compareTo("") != 0 ? apartado.getIdSap() : null;																
			this.mensaje    = "OK";
			
		}catch(PersistenceException  ibe){			   
			   logger.error("Error.", ibe);			   			   
		}catch(Exception e){			   
			   logger.error("Error.", e);			   
		}		
		return "listado";
	 }

	public List<ApartadoDTO> getApartados() {
		return apartados;
	}
	public String getMensaje() {
		return mensaje;
	}
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}
	public void setIdApartado(String idApartado) {
		this.idApartado = idApartado;
	}
	public String getIdApartado() {
		return idApartado;
	}
	public void setAmortizable(String amortizable) {
		this.amortizable = amortizable;
	}		
}
