package com.mx.dla.dda.admin.catalogos.tipoCambio.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.tipoCambio.bos.TipoCambioBO;
import com.mx.dla.dda.admin.catalogos.tipoCambio.dtos.MesTiposCTDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambio.dtos.TipoCambioDTO;
import com.mx.dla.dda.catalogos.dtos.PaisVentaDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class TipoCambioAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private List<Integer> annios;
	private List<PaisVentaDTO> paises;
	private Integer annio;
	private PaisVentaDTO pais;
	private List<TipoCambioDTO> nombreTipos;
	private List<MesTiposCTDTO> mesesTipos;
	private boolean exito;
	private String mensaje;
	private String error;

	@Autowired
	private TipoCambioBO tipoCambioBO;

	@Override
	public String execute() throws Exception {

		return SUCCESS;
	}

	public String obtenerLista() {

		annios = tipoCambioBO.obtenerAnnios();
		try {
			paises = tipoCambioBO.obtenerPaises();
		}catch (TransaccionException e) {
			error = e.getMessage();
		}
		

		return SUCCESS;
	}

	public String obtenerMesTipo() {
		
		try {
			nombreTipos = tipoCambioBO.obtenerNombreTipos();
			mesesTipos = tipoCambioBO.obtenerMesTipo(annio, pais, nombreTipos);
		}catch (TransaccionException e) {
			error = e.getMessage();
		}
		
		
		return SUCCESS;
	}
	
	public String guardarCambio() {
		
		try{
			exito = tipoCambioBO.guardarCambios(mesesTipos);
			mensaje = "Se actualizaron los cambios.";
		}catch (TransaccionException e) {
			error = e.getMessage();
			mensaje = error; // revisar el uso 
		}
		
		return SUCCESS;
	}

	public List<Integer> getAnnios() {
		return annios;
	}

	public void setAnnios(List<Integer> annios) {
		this.annios = annios;
	}

	public List<PaisVentaDTO> getPaises() {
		return paises;
	}

	public void setPaises(List<PaisVentaDTO> paises) {
		this.paises = paises;
	}

	public Integer getAnnio() {
		return annio;
	}

	public void setAnnio(Integer annio) {
		this.annio = annio;
	}

	public PaisVentaDTO getPais() {
		return pais;
	}

	public void setPais(PaisVentaDTO pais) {
		this.pais = pais;
	}

	public List<TipoCambioDTO> getNombreTipos() {
		return nombreTipos;
	}

	public void setNombreTipos(List<TipoCambioDTO> nombreTipos) {
		this.nombreTipos = nombreTipos;
	}

	public List<MesTiposCTDTO> getMesesTipos() {
		return mesesTipos;
	}

	public void setMesesTipos(List<MesTiposCTDTO> mesesTipos) {
		this.mesesTipos = mesesTipos;
	}

	public boolean isExito() {
		return exito;
	}

	public void setExito(boolean exito) {
		this.exito = exito;
	}

	public String getMensaje() {
		return mensaje;
	}

	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}
	
}