package com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.bos.EstudioBO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoEstudioDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambio.dtos.TipoCambioDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.bos.TipoCambioAddOnsBO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.MesTiposAddOnsCTDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;

public class TipoCambioAddOnsAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private List<Integer> annios;
	private List<EstudioAddonDTO> estudios;
	private Integer annio;
	private String estudio;
	private List<TipoCambioDTO> nombreTipos;
	private List<MesTiposAddOnsCTDTO> mesesTipos;
	private boolean exito;
	private String mensaje;
	private String error;
	
	
	private File file;
	private String fileContentType;
	private String fileFileName;
	private InputStream fileInputStream;
	
	@Autowired
	private EstudioBO estudioBO;
	
	@Autowired
	private TipoCambioAddOnsBO tipoCambioAddOnsBO;

	@Override
	public String execute() throws Exception {

		return SUCCESS;
	}

	public String obtenerLista() {
		annios = tipoCambioAddOnsBO.obtenerAnnios();
		estudios = estudioBO.catalogoEstudiosAddOn();

		return SUCCESS;
	}

	public String cargaMasiva() throws ExcelMapperException, IOException {
		try{
			nombreTipos = tipoCambioAddOnsBO.obtenerNombreMeses();
			tipoCambioAddOnsBO.cargaMasivaTipoCambioAddOn(Long.valueOf(annio), Long.parseLong(estudio), file, fileFileName, nombreTipos);
		}catch(Exception e){
			logger.error("Error ",e);
			e.printStackTrace();
		}
		
		return SUCCESS;
	}
	
	
    public String exportarReporte() {
        try {
           
            fileInputStream = tipoCambioAddOnsBO.obtenerStreamReporte(Long.parseLong(estudio),annio);
            System.out.println("ao para descarga"+annio);
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return SUCCESS;
    }
	
	
	public String obtenerMesTipo() {
		try {
			nombreTipos = tipoCambioAddOnsBO.obtenerNombreMeses();
			mesesTipos = tipoCambioAddOnsBO.obtenerMesTipo(Long.valueOf(estudio), annio, nombreTipos);
		}catch (TransaccionException e) {
			error = e.getMessage();
		}
		
		return SUCCESS;
	}
	
	public String guardarCambio() {
		
		try{
			exito = tipoCambioAddOnsBO.guardarCambios(mesesTipos);
			mensaje = "Se actualizaron los cambios.";
		}catch (TransaccionException e) {
			error = e.getMessage();
			mensaje = error; // revisar el uso 
		}
		
		return SUCCESS;
	}

	public List<Integer> getAnnios() {
		return annios;
	}

	public void setAnnios(List<Integer> annios) {
		this.annios = annios;
	}
	
	public Integer getAnnio() {
		return annio;
	}

	public void setAnnio(Integer annio) {
		this.annio = annio;
	}

	public List<TipoCambioDTO> getNombreTipos() {
		return nombreTipos;
	}

	public void setNombreTipos(List<TipoCambioDTO> nombreTipos) {
		this.nombreTipos = nombreTipos;
	}

	public List<MesTiposAddOnsCTDTO> getMesesTipos() {
		return mesesTipos;
	}

	public void setMesesTipos(List<MesTiposAddOnsCTDTO> mesesTipos) {
		this.mesesTipos = mesesTipos;
	}

	public boolean isExito() {
		return exito;
	}

	public void setExito(boolean exito) {
		this.exito = exito;
	}

	public String getMensaje() {
		return mensaje;
	}

	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public List<EstudioAddonDTO> getEstudios() {
		return estudios;
	}

	public void setEstudios(List<EstudioAddonDTO> estudios) {
		this.estudios = estudios;
	}

	public EstudioBO getEstudioBO() {
		return estudioBO;
	}

	public void setEstudioBO(EstudioBO estudioBO) {
		this.estudioBO = estudioBO;
	}

	public String getEstudio() {
		return estudio;
	}

	public void setEstudio(String estudio) {
		this.estudio = estudio;
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}

	public String getFileContentType() {
		return fileContentType;
	}

	public void setFileContentType(String fileContentType) {
		this.fileContentType = fileContentType;
	}

	public String getFileFileName() {
		return fileFileName;
	}

	public void setFileFileName(String fileFileName) {
		this.fileFileName = fileFileName;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}
}