package com.mx.dla.dda.admin.catalogos.transacciones.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.transacciones.bos.TransaccionesBO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.EstudiosTransDTO;
import com.mx.dla.global.actions.BaseAction;

import lombok.Data;

@Data
public class EstudiosTransAction extends BaseAction {
	
	private List<EstudiosTransDTO> estudiosTrans;
	private EstudiosTransDTO estudio;
	private String nombreEstudio;
	private String revenueShare;
	private String idEstudio;
	private String valido;
	
	@Autowired
	private TransaccionesBO transacciones;
	
	@Override
	public String execute() throws Exception {
		setPmns();
		return SUCCESS;
	}
	
	public String listadoEstudiosTrans() {
		setEstudiosTrans(transacciones.getEstudiosTrans());
		return SUCCESS;
	}
	
	public void setPmns() {
		logger.debug("pmn : " + this.getPmn() + "pmnReturn : " + this.getPmnReturn());
		this.getSession().put("pmn", 211);
		this.getSession().put("pmnReturn", 211);
		this.setPmn("211");
		this.setPmnReturn("211");
	}
	
	public String dirigirAgregar() throws Exception {					
		setPmns();
		return SUCCESS;
	}
	
	public String guardaEstudioTrans() {
		EstudiosTransDTO estudio = new EstudiosTransDTO();
		estudio.setNombre(nombreEstudio);
		estudio.setRevenueShare(revenueShare);
		transacciones.agregarEstudioTrans(estudio);
		setPmns();
		return SUCCESS;
	}
	
	public String eliminaEstudioTrans() {
		EstudiosTransDTO estudio = new EstudiosTransDTO();
		estudio.setIdEstudio(idEstudio);
		estudio.setBorrado("0");
		transacciones.eliminarEstudio(estudio);
		setPmns();
		return SUCCESS;
	}
	
	public String llamaObtenEstudio() throws Exception {	
		setEstudio(transacciones.getEstudioTransById(idEstudio));
		setPmns();
		return SUCCESS;
	}
	
	public String llamaActualizaEstudio() throws Exception {	
		EstudiosTransDTO estudio = new EstudiosTransDTO();
		estudio.setIdEstudio(idEstudio);
		estudio.setNombre(nombreEstudio);
		estudio.setRevenueShare(revenueShare);
		estudio.setBorrado("0");
		transacciones.updateEstudioTrans(estudio);
		setPmns();
		return SUCCESS;
	}

}
