package com.mx.dla.dda.contrato.condicionesTransaccion.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.condicionesTransaccion.bos.CondicionesTransaccionBO;
import com.mx.dla.dda.contrato.condicionesTransaccion.dtos.CondicionesTransaccionDTO;

public class GuardarTransaccionAction extends BaseContratoAction
implements ServletRequestAware, ServletResponseAware{
	
	private static final long serialVersionUID = 1L;
	private Logger log = Logger.getLogger(this.getClass());

	private String data;
	
	
	ObjectMapper mapper = new ObjectMapper();
	
	@Autowired
	private CondicionesTransaccionBO transaccionBO;
	private CondicionesTransaccionDTO transaccionDTO=new CondicionesTransaccionDTO();

	private HttpServletRequest request;
	

	@Override
	public String execute() throws Exception {
		log.debug("ESTOY ENTRANDO AL ACTION GUARDAR TRANSACCION");
		//Long idContrato= null;
		try {
			log.debug("data "+data);
			transaccionDTO = mapper.readValue(data, CondicionesTransaccionDTO.class);
			log.debug("TRANSACCION:"+transaccionDTO.toString());
			transaccionBO.guardar(transaccionDTO);
			setJustificacion(transaccionDTO.getJustificacion());
			//idContrato=Long.valueOf(transaccionDTO.getIdContrato());
			setIdContrato( transaccionDTO.getIdContrato());
			if(getJustificacion() != null && !"".equals(getJustificacion())){
				guardarJustificacion();
				setJustificacion("");
			}
		} catch (Exception e) {
			log.error("ERROR:",e);
			log.error("Causa: "+e.getCause());
		}
		return SUCCESS;
		
		
	}

	@Override
	public void setServletResponse(HttpServletResponse arg0) {
		// TODO Auto-generated method stub
		
	}

	public String getData() {
		return data;
	}

	public void setData(String data) {
		this.data = data;
	}

	public CondicionesTransaccionBO getTransaccionBO() {
		return transaccionBO;
	}

	public void setTransaccionBO(CondicionesTransaccionBO transaccionBO) {
		this.transaccionBO = transaccionBO;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}
	
	

}
