package com.mx.dla.dda.contrato.generales.actions;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;

import lombok.Data;

@Data
@Controller
@Scope("request")
public class CambiarAddendumAction extends BaseContratoAction{
	
	
	private static final long serialVersionUID = 1L;
	
	private Long idContrato;
	private String numeroContrato;
	
	@Autowired
	private GeneralesBO generalesBO;
	
	@Override
	public String execute() {
		
		logger.debug("idContrato a cambiar : [{}]", idContrato);
		generalesBO.cambiarAddendum(idContrato, numeroContrato);
		logger.debug("Contrato virtual No. " + idContrato + " actualizado a addendum.");
		
		return SUCCESS;
	}
	
}
