package com.mx.dla.dda.contrato.generales.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.PoblarGeneralesBO;

@Controller
@Scope("request")
public class ValidaComboAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;
	
	private List<Long> idsCatalogo;
	private List<Long> noQuitar;
	private String tipoCatalogo;
	private Long idContratoCat;
	
	@Autowired
	PoblarGeneralesBO poblarGeneralesBO;
	
	public String execute() {
		
		if(idContratoCat == null) {
			idContratoCat = 0L;
		}
		
		setNoQuitar(poblarGeneralesBO.validaIdsCatalogo(idsCatalogo, idContratoCat, tipoCatalogo));
		
		return SUCCESS;
	}
	
	public void setIdsCatalogo(List<Long> idsCatalogo) {
		this.idsCatalogo = idsCatalogo;
	}
	
	public List<Long> getIdsCatalogo() {
		return idsCatalogo;
	}
	
	public void setNoQuitar(List<Long> noQuitar) {
		this.noQuitar = noQuitar;
	}
	
	public List<Long> getNoQuitar() {
		return noQuitar;
	}
	
	public void setTipoCatalogo(String tipoCatalogo) {
		this.tipoCatalogo = tipoCatalogo;
	}
	
	public String getTipoCatalogo() {
		return tipoCatalogo;
	}
	
	public void setIdContratoCat(Long idContratoCat) {
		this.idContratoCat = idContratoCat;
	}
	
	public Long getIdContratoCat() {
		return idContratoCat;
	}
	
}
