package com.mx.dla.dda.contrato.license.titulo.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.common.constants.ContratoConstats;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.license.titulo.bos.TituloFeeAsyncBO;
import com.mx.dla.dda.contrato.titulo.dtos.DatosAmortizacion;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulos.dtos.PresupuestoTitulo;
import com.mx.dla.global.actions.BaseAction;

public class TituloFeeAsyncAction extends BaseAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 701974940988115146L;

	@Autowired
	private TituloFeeAsyncBO tituloAsyncBO;

	private List<CatalogoDTO> categoriasDDATodas;
	private List<CatalogoDTO> listas;
	private List<CatalogoDTO> categoriasDDAFecha;
	private List<CatalogoDTO> categoriaContrato;
	private List<String> sugerencias;
	private PresupuestoTitulo presupuesto;
	private DatosAmortizacion datosAmortizacion; 

	private String error;
		
	public String buscaCategoriasDDAFecha() {
		ContratoDTO     ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
		categoriasDDAFecha = tituloAsyncBO.buscaCategoriasDDAFecha(ct);
		return SUCCESS;
	}
	
	public String buscaCategoriasDDATodas() {
		ContratoDTO ct = (ContratoDTO) getSession().get(
				ContratoConstats.CONTRATO_SESSION);
		categoriasDDATodas = tituloAsyncBO.buscaCategoriasDDATodas(ct);
		return SUCCESS;
	}
	
	public String buscaListas() {
		ContratoDTO ct = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
		listas = tituloAsyncBO.buscaListas(ct);
		return SUCCESS;
	}
	
	public String buscaCategoriaContrato() {
		ContratoDTO ct    = (ContratoDTO) getSession().get(ContratoConstats.CONTRATO_SESSION);
		categoriaContrato = tituloAsyncBO.buscaCategoriaContrato(ct);
		return SUCCESS;
	}

	public String buscaSugerencias() {
		ContratoDTO ct = (ContratoDTO) getSession().get(
				ContratoConstats.CONTRATO_SESSION);
		sugerencias = tituloAsyncBO.buscaSugerencias(ct);
		return SUCCESS;
	}

	public String buscarPresupuesto()
	{
		try{
			Lista li = (Lista) getSession().get( ContratoConstats.LISTA_SESSION);
			ContratoDTO ct = (ContratoDTO) getSession().get( ContratoConstats.CONTRATO_SESSION);
			presupuesto = tituloAsyncBO.buscarPresupuesto(ct,li,"REAL"); 
			//presupuesto = tituloAsyncBO.buscarPresupuesto(ct,li,"ESPEJO"); 
		}
		catch(Exception e)
		{
			logger.error("Error ",e);
			error="Ocurrio un error con la operacion";
		}
		return SUCCESS;
	}
	
	public String buscaAmortizaciones()
	{
		try{
		ContratoDTO ct = (ContratoDTO) getSession().get( ContratoConstats.CONTRATO_SESSION);
		Lista li = (Lista) getSession().get( ContratoConstats.LISTA_SESSION);
		datosAmortizacion = tituloAsyncBO.buscarDatosAmortizacion(ct , li);
		}
		catch(Exception e)
		{
			logger.error("Error ",e);
			error="Ocurrio un error con la operacion";
		}
		return SUCCESS;
	}
	
	public List<CatalogoDTO> getCategoriasDDATodas() {
		return categoriasDDATodas;
	}

	public void setCategoriasDDATodas(List<CatalogoDTO> categoriasDDATodas) {
		this.categoriasDDATodas = categoriasDDATodas;
	}

	public List<CatalogoDTO> getListas() {
		return listas;
	}

	public void setListas(List<CatalogoDTO> listas) {
		this.listas = listas;
	}

	public List<CatalogoDTO> getCategoriasDDAFecha() {
		return categoriasDDAFecha;
	}

	public void setCategoriasDDAFecha(List<CatalogoDTO> categoriasDDAFecha) {
		this.categoriasDDAFecha = categoriasDDAFecha;
	}

	public List<CatalogoDTO> getCategoriaContrato() {
		return categoriaContrato;
	}

	public void setCategoriaContrato(List<CatalogoDTO> categoriaContrato) {
		this.categoriaContrato = categoriaContrato;
	}

	public List<String> getSugerencias() {
		return sugerencias;
	}

	public void setSugerencias(List<String> sugerencias) {
		this.sugerencias = sugerencias;
	}

	public PresupuestoTitulo getPresupuesto() {
		return presupuesto;
	}
	public void setPresupuesto(PresupuestoTitulo presupuesto) {
		this.presupuesto = presupuesto;
	}
	
	public String getError() {
		return error;
	}
	
	public void setError(String error) {
		this.error = error;
	}
	
	public DatosAmortizacion getDatosAmortizacion() {
		return datosAmortizacion;
	}
	
	public void setDatosAmortizacion(DatosAmortizacion datosAmortizacion) {
		this.datosAmortizacion = datosAmortizacion;
	}
}
