package com.mx.dla.dda.contrato.minimoseleccion.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.AnnioDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoMinimoSeleccionDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoCategoriaDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoCostoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoFlatDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.MontoRealDTO;

public class MinSeleccionAction extends BaseContratoAction {

	private static final long serialVersionUID = 21363082260499407L;

	private List<ContratoPagoDTO> periodos;

	private List<ContratoPagoCategoriaDTO> categorias;

	private List<AnnioDTO> annios;

	private List<AnnioDTO> anniosPeriodo;

	private List<ContratoPagoFlatDTO> costosFlat;

	private List<ContratoPagoCostoDTO> costosSuscriptores;

	private List<ContratoMinimoSeleccionDTO> minimosSeleccion;
	
	private List<MontoRealDTO> montosReales;
	
	private Integer guardadoStatus;
	
	private String mensajeExcepcion;

	@Autowired
	private MinimoSeleccionBO minimoSeleccionBO;
	
	@Autowired
	private GeneralesBO generalesBO;
	
	public String primeraCarga(){
		
		Long idContrato = (Long) this.getSession().get("idContrato");
		ContratoDTO ct = generalesBO.obtenContrato(idContrato);			
		setEstatusContrato(ct.getIdEstatus());
		buscarJustificaciones();
		return SUCCESS;

	}

	public String obtenInformacion() {


		try {
					
			Long idContrato = (Long) this.getSession().get("idContrato");
			logger.debug("idContrato: " + idContrato);

			ContratoDTO ct = generalesBO.obtenContrato(idContrato);			
			setEstatusContrato(ct.getIdEstatus());
			
			periodos = minimoSeleccionBO.consultaInformacionPeriodos(idContrato);
			logger.debug("periodos: " + periodos);
			categorias = minimoSeleccionBO.consultaInformacionCategorias(idContrato);
			logger.debug("categorias: " + categorias);
			annios = minimoSeleccionBO.consultaInformacionAnnios(idContrato);
			logger.debug("annios: " + annios);
			costosFlat = minimoSeleccionBO.consultaInformacionCostoFlat(idContrato);
			logger.debug("costosFlat: " + costosFlat);
			costosSuscriptores = minimoSeleccionBO.consultaInformacionCostoSubscriptores(idContrato);
			logger.debug("costosSuscriptores: " + costosSuscriptores);
			minimosSeleccion = minimoSeleccionBO.consultaInformacionMinimos(idContrato);
			logger.debug("minimosSeleccion: " + minimosSeleccion);
			anniosPeriodo = minimoSeleccionBO.consultaInformacionAnniosPorPeriodo(idContrato);
			logger.debug("anniosPeriodo : [{}]", anniosPeriodo);
			montosReales = minimoSeleccionBO.consultaInformacionMontosReales(idContrato); 
			logger.debug("montosReales : [{}]", montosReales);
			guardadoStatus = 0;
			
			//setMensajeExcepcion("Se obtuvo la informacin.");

		} catch (Exception e) {
			logger.debug("Exception : [{}]", e);
			setMensajeExcepcion("Fallo la carga de informacin.");
		}

		return SUCCESS;
	}

	public String guardaInformacion() {

		logger.debug("minimosSeleccion: " + minimosSeleccion);

		try {
			
			Long idContrato = (Long) this.getSession().get("idContrato");

			logger.debug("idContrato: " + idContrato);

			ContratoDTO ct = generalesBO.obtenContrato(idContrato);			
			setEstatusContrato(ct.getIdEstatus());

			for (ContratoMinimoSeleccionDTO item : minimosSeleccion)
				minimoSeleccionBO.actualizaMinimoMonto(
						item.getIdContratoPago(), item.getIdPagoCategoria(),
						item.getAnnio(), item.getMinimoSeleccion());
			
			if (getJustificacion() != null && !"".equals(getJustificacion())) {
				guardarJustificacion();
				setJustificacion("");
			}

			buscarJustificaciones();

			guardadoStatus = 1;
			//guardadoStatusMessage = "La informacin se ha guardado con exito";
			//addActionMessage("La informacion se ha guardado con exito");

		} catch (Exception e) {
			logger.debug("Exception : [{}]", e);
			setMensajeExcepcion("Fallo al guardar informacin.");
			guardadoStatus = -1;	
		}

		return SUCCESS;

	}

	public List<ContratoPagoDTO> getPeriodos() {
		return periodos;
	}

	public void setPeriodos(List<ContratoPagoDTO> periodos) {
		this.periodos = periodos;
	}

	public List<ContratoPagoCategoriaDTO> getCategorias() {
		return categorias;
	}

	public void setCategorias(List<ContratoPagoCategoriaDTO> categorias) {
		this.categorias = categorias;
	}

	public List<AnnioDTO> getAnnios() {
		return annios;
	}

	public void setAnnios(List<AnnioDTO> annios) {
		this.annios = annios;
	}

	public List<ContratoPagoFlatDTO> getCostosFlat() {
		return costosFlat;
	}

	public void setCostosFlat(List<ContratoPagoFlatDTO> costosFlat) {
		this.costosFlat = costosFlat;
	}

	public List<ContratoPagoCostoDTO> getCostosSuscriptores() {
		return costosSuscriptores;
	}

	public void setCostosSuscriptores(
			List<ContratoPagoCostoDTO> costosSuscriptores) {
		this.costosSuscriptores = costosSuscriptores;
	}

	public List<ContratoMinimoSeleccionDTO> getMinimosSeleccion() {
		return minimosSeleccion;
	}

	public void setMinimosSeleccion(
			List<ContratoMinimoSeleccionDTO> minimosSeleccion) {
		this.minimosSeleccion = minimosSeleccion;
	}

	public List<AnnioDTO> getAnniosPeriodo() {
		return anniosPeriodo;
	}

	public void setAnniosPeriodo(List<AnnioDTO> anniosPeriodo) {
		this.anniosPeriodo = anniosPeriodo;
	}

	public Integer getGuardadoStatus() {
		return guardadoStatus;
	}

	public void setGuardadoStatus(Integer guardadoStatus) {
		this.guardadoStatus = guardadoStatus;
	}
	
	public void setMontosReales(List<MontoRealDTO> montosReales) {
		this.montosReales = montosReales;
	}
	
	public List<MontoRealDTO> getMontosReales() {
		return montosReales;
	}
	
	public void setMensajeExcepcion(String mensajeExcepcion) {
		this.mensajeExcepcion = mensajeExcepcion;
	}
	
	public String getMensajeExcepcion() {
		return mensajeExcepcion;
	}

}
