package com.mx.dla.dda.contrato.terminos.actions;

import org.apache.ibatis.exceptions.PersistenceException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.constants.ContratoConstats;
import com.mx.dla.dda.contrato.terminos.bos.TerminosBO;
import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoDTO;
import com.opensymphony.xwork2.Action;

public class ContratoTerminosAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	@Autowired
	private TerminosBO terminosBO; 
		
	private TerminoDTO          termino;
	private ContratoConsultaDTO contrato;
	private String              mensaje;
	
	public String index(){
		return Action.SUCCESS;
	}
	
	public String obtenerTermino(){
		
		try
		{
			Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);		
			termino  = terminosBO.getTerminos(idC);
			contrato = terminosBO.getInformacionContrato(idC, termino);
		}catch(PersistenceException  ibe){
			   this.mensaje = "Ocurri un error al obtener los datos.";
			   logger.error("Error en [" + this.getClass() +"]", ibe);			   
			   
		}catch(Exception e){
			   this.mensaje = "Ocurri un error al obtener los datos.";
			   logger.error("Error en [" + this.getClass() +"]", e);			   
		}
		return "regresar";
	}
	
	public String guardarTermino(){
		try
		{
			Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);
			
			ObjectMapper mapper = new ObjectMapper();													
			termino = mapper.readValue(mensaje, TerminoDTO.class);
			terminosBO.guardarTerminos(termino, idC);
			
			termino  = terminosBO.getTerminos(idC);
			contrato = terminosBO.getInformacionContrato(idC, termino);
			this.mensaje = null;
		}catch(PersistenceException  ibe){
			   this.mensaje = "Ocurri un error al guardar los datos.";
			   logger.error("Error en [" + this.getClass() +"]", ibe);			   
			   
		}catch(Exception e){
			   this.mensaje = "Ocurri un error al guardar los datos.";
			   logger.error("Error en [" + this.getClass() +"]", e);			   
		}
		return "regresar";
	}

	
	
	public TerminoDTO getTermino() {
		return termino;
	}
	public void setTermino(TerminoDTO termino) {
		this.termino = termino;
	}
	public ContratoConsultaDTO getContrato() {
		return contrato;
	}
	public void setContrato(ContratoConsultaDTO contrato) {
		this.contrato = contrato;
	}
	public String getMensaje() {
		return mensaje;
	}
	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}		
}
