package com.mx.dla.dda.ncredito.listado.actions;

import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.struts2.ServletActionContext;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.bos.CatalogosBO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoGeneralDTO;
import com.mx.dla.dda.ncredito.listado.bos.NotaCreditoListadoBO;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;

public class NotaCreditoListadoAction extends BaseContratoAction {

	private static final long					serialVersionUID = 1L;

	private List<ContratoNotaCreditoGeneralDTO>	listadoNotasCredito;
	private List<EstudioDTO>					estudios;
	private String								numeroFactura;
	private Long								idNotaCredito;
	private Integer								idOperacion;
	private String								msgError;
	private String								msgExito;
	private String								jsonRequest;

	@Autowired
	private NotaCreditoListadoBO				notaCreditoListadoBO;

	@Autowired
	private CatalogosBO							catalogosBO;

	public String execute() {
		ObjectMapper mapper = new ObjectMapper();

		try {

			estudios = mapper.readValue(jsonRequest, mapper.getTypeFactory().constructCollectionType(List.class, EstudioDTO.class));
			numeroFactura = numeroFactura.compareTo("") == 0 ? null : numeroFactura;

			List<Long> ids = new ArrayList<Long>();
			for (EstudioDTO item : estudios)
				ids.add(item.getIdEstudio());

			listadoNotasCredito = notaCreditoListadoBO.getListadoNotasCredito(ids, numeroFactura);

		}
		catch (PersistenceException ibe) {
			this.msgError = "Error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", ibe);

		}
		catch (Exception e) {
			this.msgError = "Error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", e);
		}

		return Action.SUCCESS;
	}

	public String operarNotaCredito() {
		// identificdor operacion 1:nuevo, 2:editar, 3: ver, 4: eliminar
		String paramValue = ServletActionContext.getRequest().getParameter("pmn");
		this.getSession().put("pmn", paramValue);
		this.getSession().put("pmnReturn", ServletActionContext.getRequest().getParameter("pmnReturn"));

		try {

			if (idOperacion.intValue() == 1 || idOperacion.intValue() == 2 || idOperacion.intValue() == 3) {
				if (idOperacion == 1)
					ActionContext.getContext().getSession().put("idNotaCredito", null);
				else
					ActionContext.getContext().getSession().put("idNotaCredito", idNotaCredito);
				return "operacion";
			}
			if (idOperacion.intValue() == 4) {
				notaCreditoListadoBO.eliminarNotaCredito(idNotaCredito);
				this.msgExito = "Los datos han sido eliminados.";
			}

		}
		catch (PersistenceException ibe) {
			this.msgError = "Error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", ibe);

		}
		catch (Exception e) {
			this.msgError = "Error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", e);
		}

		return Action.SUCCESS;
	}

	public String obtenerEstudios() {

		try {
			estudios = catalogosBO.obtenListaEstudios();
		}
		catch (PersistenceException ibe) {
			this.msgError = "Error al realizar el proceso.";
			logger.error("Error en [" + this.getClass() + "]", ibe);
		}
		catch (Exception e) {
			this.msgError = "Error al realizar el proceso.";
			logger.error("Error en [" + this.getClass() + "]", e);
		}
		return Action.SUCCESS;
	}

	public List<ContratoNotaCreditoGeneralDTO> getListadoNotasCredito() {
		return listadoNotasCredito;
	}

	public void setEstudios(List<EstudioDTO> estudios) {
		this.estudios = estudios;
	}

	public List<EstudioDTO> getEstudios() {
		return estudios;
	}

	public void setNumeroFactura(String numeroFactura) {
		this.numeroFactura = numeroFactura;
	}

	public void setIdNotaCredito(Long idNotaCredito) {
		this.idNotaCredito = idNotaCredito;
	}

	public String getMsgError() {
		return msgError;
	}

	public String getMsgExito() {
		return msgExito;
	}

	public void setIdOperacion(Integer idOperacion) {
		this.idOperacion = idOperacion;
	}

	public void setJsonRequest(String jsonRequest) {
		this.jsonRequest = jsonRequest;
	}

}
