package com.mx.dla.dda.reporte.pago.actions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.pago.bos.ReporteSuscriptoresBO;
import com.mx.dla.dda.reporte.pago.dtos.ReporteAddOnRowDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReportePagoDTO;

import lombok.Data;

@Data
public class ReporteCargaEPAction extends BaseContratoAction {
	private static final long serialVersionUID = 1L;

	private Long idCon;
	private String fechaInicio;
	private Date fechaFin;
	private String[] llaves;
	private List<ReportePagoDTO> infoReporte;
	private Long idEstudio;
	private List<ReporteAddOnRowDTO> reporte;
	private String[] encabezado;

	@Autowired
	private ReporteSuscriptoresBO ReporteSuscriptoresBO;

	public String execute() {
		setEncabezado(ReporteSuscriptoresBO.obtenerEncabezadoCA());
		reporte = ReporteSuscriptoresBO.obteneReporteCA(dateFormat(),idEstudio);
		logger.info("Reporte obtenido regresando al front" + reporte.size());
		return SUCCESS;
	}
	
	public String guardarHistorico() {
		ReporteSuscriptoresBO.cerrarHistorico(dateFormat(),idEstudio);
		return SUCCESS;
	}
	
	public Date dateFormat() {
		
		SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy"); 
		Date fecha=null;
		try {
			fecha = formato.parse("01/"+fechaInicio);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		
		return fecha;
		
	}
	
}
