package com.mx.dla.dda.reporte.rys.actions;

import java.io.InputStream;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.reporte.oyp.dtos.ReporteOveragesYPaymentsVistaDTO;
import com.mx.dla.dda.reporte.rys.bos.ReporteRevenueYSplitsBO;

public class ReporteRevenueYSplitsViewAction extends BaseContratoAction {

	private static final long				 serialVersionUID = -8363640992586901052L;
	private String							 fecha;
	private String							 tipoAbono;
	private ReporteOveragesYPaymentsVistaDTO reporteVista;
	private InputStream						 fileInputStream;
	private Long							 idEstudio;
	private String							 claveReporte;
	private List<EstudioDTO>				 estudios;
	private String                           validaEstatusCarga;

	/*
	 * private String fileName; private String tipoReporte; private File file;
	 * private String fileFileName;
	 */
	private String							 errorMensaje;

	@Autowired
	private ReporteRevenueYSplitsBO			 reporteRevenueYSplitsBO;

	public String obtenerDatosReporte() {

		try {

			logger.info("fecha: {}", fecha);
			logger.info("tipoAbono: {}", tipoAbono);
			logger.info("claveReporte: {}", claveReporte);
			logger.info("idEstudio: {}", idEstudio);
			logger.info("validaEstatusCarga: {}", validaEstatusCarga);

			reporteVista = reporteRevenueYSplitsBO.obtenerReporteRevenueYSplitsVista(fecha, tipoAbono, claveReporte, idEstudio, validaEstatusCarga);

			logger.info("getTabla: {}", reporteVista.getTabla());
			logger.info("getPheader: {}", reporteVista.getHeader());
			logger.info("getRheader: {}", reporteVista.getColumnCfg());

		}
		catch (Exception e) {
			errorMensaje = e.getMessage();
		}

		return SUCCESS;
	}

	public String obtenerEstudios() {

		try {
			estudios = reporteRevenueYSplitsBO.obtenerEstudios();
			logger.info("estudios: {}", estudios);
		}
		catch (Exception e) {
			errorMensaje = e.getMessage();
		}

		return SUCCESS;
	}

	public String exportarReporte() {
		try {

			logger.info("fecha: {}", fecha);
			logger.info("tipoAbono: {}", tipoAbono);
			logger.info("claveReporte: {}", claveReporte);
			logger.info("idEstudio: {}", idEstudio);

			UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
			fileInputStream = reporteRevenueYSplitsBO.obtenerStreamReporte(fecha, tipoAbono, claveReporte, idEstudio, usuario.getExpediente(), validaEstatusCarga);
			// fileName = "nombreTest";
		}
		catch (Exception e) {
			errorMensaje = e.getMessage();
		}
		return SUCCESS;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public String getErrorMensaje() {
		return errorMensaje;
	}

	public void setErrorMensaje(String errorMensaje) {
		this.errorMensaje = errorMensaje;
	}

	public String getFecha() {
		return fecha;
	}

	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	public String getTipoAbono() {
		return tipoAbono;
	}

	public void setTipoAbono(String tipoAbono) {
		this.tipoAbono = tipoAbono;
	}

	public ReporteOveragesYPaymentsVistaDTO getReporteVista() {
		return reporteVista;
	}

	public void setReporteVista(ReporteOveragesYPaymentsVistaDTO reporteVista) {
		this.reporteVista = reporteVista;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public String getClaveReporte() {
		return claveReporte;
	}

	public void setClaveReporte(String claveReporte) {
		this.claveReporte = claveReporte;
	}

	public List<EstudioDTO> getEstudios() {
		return estudios;
	}

	public void setEstudios(List<EstudioDTO> estudios) {
		this.estudios = estudios;
	}

	public String getValidaEstatusCarga() {
		return validaEstatusCarga;
	}

	public void setValidaEstatusCarga(String validaEstatusCarga) {
		this.validaEstatusCarga = validaEstatusCarga;
	}
	
	

}
