var idEstudio;

$(document).ready(
	function() {
		inicial();
		
		$('#fechaInicio').datepicker({
		changeYear: false,
	    changeMonth: false,
	    dateFormat: "yy/mm/dd",
	});
	
	$('#fechaFin').datepicker({
		changeYear: false,
	    changeMonth: false,
	    dateFormat: "yy/mm/dd",
	});
	}
);

function inicial(){
	limpiarTabla();
	realizaConsulta();
	inicializarBotones();
	$("table thead tr").addClass("encabezado");
}

function limpiarTabla(){	
	$('#divTablaIn').remove();
	var div = '<div id="divTablaIn"></div>';
	$('#divTablaExt').append(div);
	var tabla = $("<table class='table table-striped'/>").attr('id',"cataEstudio");       
	$("#divTablaIn").append(tabla);	
}

function realizaConsulta(){				
	// Obtener numero de menu
	var menu        = $("#pmn").val();
	var menuRegreso = $("#pmnReturn").val();
	var namespace = "/catalogos/excepciones/";
    var rowId=null;
    var oTable=null;
     oTable=$('#cataEstudio').dataTable({		    
	   "bAutoWidth": false,
		"oLanguage":{	"sProcessing":     "Procesando...",
						"sLengthMenu":     "Mostrar _MENU_ registros",
						"sZeroRecords":    "Sin eventos encontrados",
						"sEmptyTable":     "Sin eventos encontrados",
						"sInfo":           "Mostrando  _START_ al _END_ de  _TOTAL_ ",
						"sInfoEmpty":      "0 registros",
						"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
						"sSearch":         "Buscar:",
						"sInfoThousands":  ",",
						"sLoadingRecords": "Cargando...",
						"oPaginate": {
							"sFirst":    "Primero",
				        	"sLast":     "&Uacute;ltimo",
				        	"sNext":     "Siguiente",
				        	"sPrevious": "Anterior"
				    	}
				},
		"iDisplayLength": 10,
		"bInfo"     : false,
		"bFilter"   : true,
		"bSort"     : false,
		"bPaginate" :true,
		"sPaginationType" : "full_numbers",
		"aaSorting": [],
		"sAjaxSource": "listadoExcepciones",
		"sAjaxDataProp":"", 
	    "aoColumns": [
						{"sTitle":"Estudio", 					"mDataProp":"estudio",		"bSearchable": true, sWidth : "100px"},
						{"sTitle":"Titulo", 					"mDataProp":"titulo",		"bSearchable": true, sWidth : "50px"},
						{"sTitle":"Revenue Share", 				"mDataProp":"revenueShare",	"bSearchable": true, sWidth : "50px"},
						{"sTitle":"Fecha Inicio", 				"mDataProp":"fechaInicio",	"bSearchable": true, sWidth : "500px"},
						{"sTitle":"Fecha Fin", 					"mDataProp":"fechaFin",		"bSearchable": true, sWidth : "500px"},
						{"sTitle":"Accion",						"mDataProp":"titulo",		"bSearchable": true, sWidth : "30px"}
	          			],
	    		        'fnRowCallback': function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
	    		        
	    		        	var link = '<a onClick="actualizaExcepcion('+aData["idExcepcion"]+')" data-toggle="modal" data-target="#modalAgregaActualiza"> ' + aData["estudio"] +'</a>';
	    		        	var button = '<button class="btn btn-danger" type="button" onclick="eliminar(' + aData["idExcepcion"] + ')">Eliminar</button> ';
	    		        	$(nRow).attr("id",aData["idExcepcion"]);
	    		        	$('td:eq(0)', nRow).html(link);
	    		        	$('td:eq(1)', nRow).html(aData["titulo"]);
	    		        	$('td:eq(2)', nRow).html(aData["revenueShare"]);
	    		        	$('td:eq(3)', nRow).html(aData["fechaInicio"]);
	    		        	$('td:eq(4)', nRow).html(aData["fechaFin"]);
	    		        	$('td:eq(5)', nRow).html(button);
	   		       		}
		});
     
}

function validarAgregar(){
	
	$("#forma").validate(
		      {
		        rules: 
		        {
		        	nombreEstudio: 
		          {
		            required: true,
		            maxlength: 50,
		            regex:"^[a-zA-Z0-9 ]+$"
		          }
		        },
		        messages: 
		        {
		        	nombreEstudio: 
		          {
		            required: "Nombre del Estudio es obligatorio.",
		            maxlength: "Nombre no debe exceder 50 caracteres",
		            regex: "Nombre debe ser con caracteres alfanumericos"
		          }
		        }
	});
	
	$.validator.addMethod("regex",function(value,element,regexp){
	      var re= new RegExp(regexp);
	      return this.optional(element) || re.test(value);
	},"Only Characters from A-z");
}

function eliminar(id){
	if(confirm('¿Esta seguro de borrar este registro?')){
		var jsonString = '{"idExcepcion" : "' + id + '"}';
		var stringJson = JSON.parse(jsonString);
		callActionAjax("/catalogos/excepciones/eliminaExcepcion", stringJson, procesaRespuestaActualiza);
	}
}

function inicializarBotones(){
	$("#nuevo").click(function()  
	{		
		window.location.href = contextPath + "/catalogos/excepciones/dirigirAgregarExcepcion.action?pmn=213&pmnReturn=213";			
	});
}

function regreso(){	
	var menu = $("#pmn").val();
	if(menu == '' || menu == null || menu == undefined)
		menu = 213;
	window.location.href = contextPath + "/catalogos/excepciones/index.action?pmn=" + menu;
}

function actualizaExcepcion(idExcepcio) {	
	idExcepcion = idExcepcio;
	llamaObtenExcepcion(idExcepcion);
}

function llamaObtenExcepcion(idExcepcion) {
	var jsonString = '{"idExcepcion" : "'+ idExcepcion +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/excepciones/llamaObtenExcepcion", stringJson, procesaRespuestaObtenEstudio);
}

function procesaRespuestaObtenEstudio(jsonData) {
	console.info(JSON.stringify(jsonData));
	var exc = jsonData.excepcion;
	var stdios = jsonData.estudiosTrans;
	//debugger
	//$('#nombreEstudio').val(est.nombre);
	$('#titulo').val(exc.titulo);
	$('#revenueShare').val(exc.revenueShare);
	$('#fechaInicio').val(exc.fechaInicio);
	$('#fechaFin').val(exc.fechaFin);
	
	$('#nombreEstudio').children().remove();
	
	var option;
	for(var i = 0; i < stdios.length; i++){
		std = stdios[i];
		console.log('**************' + std.idEstudio + '******************' + std.idEstudio);
		if(exc.estudio == std.idEstudio) {
			$('#nombreEstudio').append('<option value="'+ std.idEstudio +'" selected> '+ std.nombre +' </option>');
		}else {
			console.log(std.idReporte);
			$('#nombreEstudio').append('<option value="'+ std.idEstudio +'"> '+ std.nombre +' </option>');
		}						
	}
}

function llamaActualizaEstudio() {
	
	var nombre = $('#nombreEstudio').val();
	var titulo = $('#titulo').val();
	var revenue = $('#revenueShare').val();
	var inicio = $('#fechaInicio').val();
	var fin = $('#fechaFin').val();
	var jsonString = '{"idExcepcion" : "'+ idExcepcion + '", "nombreEstudio" : "' + nombre + '", "titulo" : "' + titulo 
		+ '", "revenueShare" : "' + revenue + '", "fechaInicio" : "' + inicio + '", "fechaFin" : "' + fin +'"}';
	console.log(jsonString);
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/excepciones/llamaActualizaExcepcion", stringJson, procesaRespuestaActualiza);

}

function procesaRespuestaActualiza(jsonData) {
	
	var seRepite = jsonData.seRepiteSigla;
	
	$('#modalAgregaActualiza').modal('hide');
	
	if(!seRepite) {
		showMessage("Actualizado con exito");
	}else {
		showError("La sigla se repite en otro Estudio.");
	}
	
	inicial();	
}

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	console.log(actionRoute);
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         console.error("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
	         showError("Problemas al enviar los datos.");
	     }
	 });	
}