package com.mx.dla.dda.contrato.titulo.daos;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulos.dtos.CatTitulo;

public interface TituloDAO {

	void insertarTitulo(Titulo titulo);
	void actualizarTitulo(Titulo titulo);
	void borrarTitulo (Long idTitulo);
	void borrarTitulosPorLista (Long idLista);
	void borrarTitulosPorContrato (Long idContrato);
	
	List<Titulo> buscarTitulosPorLista(Long idLista);
	List<Titulo> buscarTitulosActivosEliminadosPorLista(Long idLista);
	List<Titulo> buscarTitulosPorIdTituloOrig(Long idTituloCntOrig);
	Titulo buscarTitulo(Long idTituloCnt);
	List<Titulo> buscarTituloFiltro(Titulo titulo);
	List<Titulo> buscarTituloAgrupableFiltro(Titulo titulo);
	
	void insertarCatTitulo(CatTitulo catTitulo);
	
	Long cuentaTitulosPorListaYDescTitulo(@Param("idLista")Long idLista,@Param("descTitulo")String descTitulo);
	
	CatTitulo buscarCatalogoTituloPorDesc(@Param("idEstudio")Long idEstudio,@Param("descTitulo")String descTitulo);
	Titulo buscarTitulosPorDescripcionEnLista(@Param("idLista")Long idLista,@Param("descTitulo")String descTitulo,
													@Param("temporada")String temporada,@Param("episodio")String episodio);
	
	Double buscarTotalCostoTitulos(@Param("idContrato")Long idContrato);
	
	List<Titulo> buscarTitulosContrato(@Param("idContrato")Long idContrato);
	void actualizarTitulosContrato(Titulo catTitulo);
	Long buscarTituloEnOtrosContratos(@Param("idContratos")List<CatalogoDTO> idContratos,@Param("fechaInicio")Date fechaInicio,
			@Param("fechaFin")Date fechaFin,@Param("descTitulo")String descTitulo, @Param("temporada")String temporada,@Param("episodio")String episodio );
	List<Titulo> buscarTituloFiltroPaginado(Titulo t);

	public Long buscarTituloEnOtrosContratosXBV(@Param("idContratos")List<CatalogoDTO> idContratos,@Param("fechaInicio")Date fechaInicio, @Param("fechaFin")Date fechaFin,@Param("idBV")String idBV);
	
	public Long buscarTitulosOtrosContratosXBV(@Param("fechaInicio")Date fechaInicio, @Param("fechaFin")Date fechaFin, @Param("idBV")String idBV, @Param("idLista")Long idLista);
	public Long buscarTitulosListaXBV         (@Param("fechaInicio")Date fechaInicio, @Param("fechaFin")Date fechaFin, @Param("idBV")String idBV, @Param("idLista")Long idLista, @Param("idTituloCnt")Long idTituloCnt);
	public Integer findCategoria(Long idCate);
	public Integer findSerie(String nombre);
	public Integer findSerieSeason(@Param("nombre")String nombre, @Param("temporada")String temporada);
	
	public String calcularVidaUtil (@Param("fechaInicial")Date fechaInicial, @Param("fechaFinal")Date fechaFinal, @Param("tipo")String tipo);
}
