package com.mx.dla.dda.reporte.amortizacion.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.dda.reporte.amortizacion.dtos.MesesAmortizacionDTO;
import com.mx.dla.dda.reporte.amortizacion.dtos.RegistroMontoDTO;

public interface ReporteAmortizacionDAO {

	public List<MesesAmortizacionDTO> obtenerMesesAmortizacion(@Param("idEstudio") Long idEstudio, @Param("fecha") String fecha);
	
	public List<RegistroMontoDTO> obtenMontosTitulosContrato(@Param("idContrato")Long idContrato, @Param("fecha")String fecha);
	
	public List<RegistroMontoDTO> obtenMontosTotalesEstudio(@Param("idEstudio")Long idEstudio, @Param("fecha")String fecha);

	public List<RegistroMontoDTO> obtenMontosTotalesContrato(@Param("idContrato")Long idContrato, @Param("fecha")String fecha, @Param("meses")Long meses);
	
	public List<ContratoConsultaDTO> consultaContratosConAmoritzacionPorEstudio(@Param("idEstudio")Long idEstudio);
	
	public List<MesesAmortizacionDTO> obtenerMesesAmortizacionSAP(@Param("idEstudio") Long idEstudio, @Param("fecha") String fecha);
	
	public List<ContratoConsultaDTO> consultaContratosConAmoritzacionPorEstudioSAP(@Param("idEstudio")Long idEstudio);
	
	public List<RegistroMontoDTO> obtenMontosTotalesContratoSAP(@Param("idContrato")Long idContrato, @Param("fecha")String fecha, @Param("meses")Long meses);
	
	public List<RegistroMontoDTO> obtenMontosTotalesEstudioSAP(@Param("idEstudio")Long idEstudio, @Param("fecha")String fecha);
	
	public List<RegistroMontoDTO> obtenMontosTitulosContratoSAP(@Param("idContrato")Long idContrato, @Param("fecha")String fecha);
}
