package com.mx.dla.dda.admin.catalogos.addons.bos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.global.bos.BaseBO;

@Component
public class EstudioAddonBO extends BaseBO {
	
	@Autowired
	private CatalogoEstudiosDAO estudiosDao;
	
	public List<EstudioAddonDTO> getEstudios(){
		return estudiosDao.catalogoEstudiosAddOn();
	}
	
	public void guardarAddon(EstudioAddonDTO addon){
		estudiosDao.guardarAddon(addon);
	}

	public EstudioAddonDTO getEstudioById(Long idEstudio) {
		return estudiosDao.catalogoEstudiosAddOnById(idEstudio);
	}

	public boolean modificaAddon(EstudioAddonDTO addon) {
		estudiosDao.updateAddon(addon);
		return Boolean.TRUE;
	}

}
