package com.mx.dla.dda.admin.catalogos.estudios.bos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoEstudioDTO;
import com.mx.dla.dda.admin.catalogos.pais.dtos.CatalogoPaisDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class EstudioBO extends BaseBO{

	@Autowired
	private CatalogoEstudiosDAO catalogoEstudiosDAO;
	
	public List<CatalogoEstudioDTO>catalogoEstudios(){
		return catalogoEstudiosDAO.catalogoEstudios();
	}
	
	public List<EstudioAddonDTO>catalogoEstudiosAddOn(){
		return catalogoEstudiosDAO.catalogoEstudiosAddOn();
	}
	
	public void updateEstudio(CatalogoEstudioDTO estudio){
		catalogoEstudiosDAO.updateEstudio(estudio);
	}
	
	public CatalogoEstudioDTO guardarEstudio(String nombreEstudio){
		CatalogoEstudioDTO estudioNuevo = new CatalogoEstudioDTO();
		estudioNuevo.setDescripcionEstudio(nombreEstudio);
		estudioNuevo.setIdGrupo(catalogoEstudiosDAO.findIdGrupoDefault());		
		catalogoEstudiosDAO.guardarEstudio(estudioNuevo);
		return estudioNuevo;
	}
	
	public CatalogoEstudioDTO catalogoEstudiosPorId(Integer id){
		 
		 CatalogoEstudioDTO estudio = catalogoEstudiosDAO.catalogoEstudiosPorId(id);
		 Integer num = catalogoEstudiosDAO.numContratosXEstuio(id.longValue());
		 if(num != null && num.intValue() > 0)
			 estudio.setTieneContratos(true);
		 else
			 estudio.setTieneContratos(false);
		 logger.debug("Busca estudio");
		 return estudio;
	}
	
	public void actulizaCatalogoEstudio(Long idEstudio, String sigla, Long campoGrupo, Integer esAddOn, String nombreAddOn) {
		
		CatalogoEstudioDTO estudio = new CatalogoEstudioDTO();
		estudio.setIdEstudio(idEstudio.intValue());
		estudio.setSiglaDda(sigla);
		estudio.setIdGrupo(campoGrupo);
		estudio.setEsAddOn(esAddOn);
		estudio.setAddOn(nombreAddOn);
		
		try {
			catalogoEstudiosDAO.actualizaEstudio(estudio);
		} catch (Exception e) {
			System.out.println("Error :"+e.getMessage());
		}
		
		
	}
	
	public boolean seRepiteSigla(Long idEstudio, String sigla){
		boolean ret = false;
		
		List<String> siglas = null;
		
		try {
			
			siglas = catalogoEstudiosDAO.obtenSiglaEstudios(idEstudio, sigla);
			
			for(String sig : siglas){
				if(sigla.equals(sig)){
					ret = true;
				}
			}
			
		}catch(Exception ex) {
			logger.error("Error : [{}]", ex);
			ret = true;
		}
		
		return ret;
	}
		
}
