package com.mx.dla.dda.contrato.common.bos;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.dla.dda.domain.model.request.PresupuestoRequest;
import com.dla.dda.domain.model.response.PresupuestoResponse;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulos.dtos.ParamValorTituloDTO;
import com.mx.dla.dda.contrato.titulos.dtos.ResponseValorTituloDTO;
import com.mx.dla.dda.contrato.ws.validapresupuesto.ParamValidaPresupuestoCntDTO;
import com.mx.dla.dda.contrato.ws.validapresupuesto.ResponseValidaPresupuestoCntDTO;
import com.mx.dla.dda.contrato.ws.validarMinimoSeleccion.ParamValidaMinimoSeleccionDTO;
import com.mx.dla.dda.contrato.ws.validarMinimoSeleccion.ResponseValidaMinimoSeleccionDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;


@Service
public class CommonRestBO extends BaseBO{

	@Autowired
	private DLARestClientFactory dlaRestClientFactory;
	
	public ResponseValorTituloDTO llamadaCostoTitulo(Date fechaInicio, Long idContrato, String origen){
		DLARestClient client = dlaRestClientFactory.getClient(DLARestServices.COSTO_TITULO);
		ParamValorTituloDTO request = new ParamValorTituloDTO();
		
		Calendar cal = Calendar.getInstance();
		cal.setTime(fechaInicio);			
		cal.set(Calendar.MONTH, cal.get(Calendar.MONTH)-1);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		DateFormat fecha = new SimpleDateFormat("dd/MM/yyyy");
		
		request.setIdContrato(idContrato.toString());			
		request.setMesCalculo(fecha.format(cal.getTime()));			
		request.setOrigenTitulos(origen);
		
		logger.info("Request rest costo [{}]",request);
		ResponseValorTituloDTO response = client.get(request, ResponseValorTituloDTO.class);
		logger.info("Response rest costo [{}]",response);
		
		return response;
	}	
	
	
	public PresupuestoResponse validaPresupuesto_deprecated(Date fechaInicio, Long idContrato, String origen)
	{
		DLARestClient clientPresupuesto = dlaRestClientFactory.getClient(DLARestServices.VALIDA_PRESUPUESTO);
		//#######		
		PresupuestoRequest req = new PresupuestoRequest();
		
		Calendar cal = Calendar.getInstance();
		cal.setTime(fechaInicio);
		
		Calendar calh = Calendar.getInstance();
		int hoy = calh.get(Calendar.YEAR) ;
		
		
		int fecIContrato = cal.get(Calendar.YEAR) ;
		
		req.setAnio( hoy>=fecIContrato ? hoy : fecIContrato );
		//ct.setAnioAmortizacion(req.getAnio());
		//req.setAnio( fecIContrato );
		req.setContrato(idContrato);
		req.setOrigenTitulos(origen);
		logger.debug("Request Presupuesto [{}]",req);
		PresupuestoResponse resp =   clientPresupuesto.get(req, PresupuestoResponse.class);
		logger.debug("Response Presupuesto [{}]",resp);
		return resp;
	}
	
	public ResponseValidaPresupuestoCntDTO validaPresupuesto(Date fechaInicio, Long idContrato, String origen) {//cuando se haya autorizado para todos, se usara este
			
		DLARestClient client = dlaRestClientFactory.getClient(DLARestServices.VALIDAR_PRESUPUESTO_POR_CONTRATO);
		
		ParamValidaPresupuestoCntDTO req = new ParamValidaPresupuestoCntDTO();
		ResponseValidaPresupuestoCntDTO resp = null;
		
		//int annioActual = 0;
		//int annioInicioContrato = 0;
		
		//Calendar cal = Calendar.getInstance();
		
		//cal.setTime(fechaInicio);
		//annioInicioContrato = cal.get(Calendar.YEAR);
		
		//cal.setTime(new Date());
		//annioActual = cal.get(Calendar.YEAR);
		
		req.setIdContrato(idContrato.toString());
		//req.setAnnio(annioActual >= annioInicioContrato ? (annioActual+"") : (annioInicioContrato+""));
		//req.setOrigen(origen);

		logger.debug("request : [{}]",  req);
		resp = client.get(req, ResponseValidaPresupuestoCntDTO.class);
		logger.debug("response : [{}]", resp);

		return resp;
	}
	
	public ResponseValidaMinimoSeleccionDTO validaMinimos(ContratoDTO ct, String origen)
	{
		DLARestClient clientMinimos = dlaRestClientFactory.getClient(DLARestServices.VALIDA_MINIMO_SELECCION);
		ParamValidaMinimoSeleccionDTO rmin = new ParamValidaMinimoSeleccionDTO();
		rmin.setIdContrato(ct.getIdContrato().toString());
		rmin.setOrigenTitulos(origen);
		
		logger.debug("Validacion minimo [{}]",rmin);
		ResponseValidaMinimoSeleccionDTO respmin= clientMinimos.get(rmin,ResponseValidaMinimoSeleccionDTO.class);
		logger.debug("Response Minimo [{}]",respmin);
		return respmin;
	}
}
