package com.mx.dla.dda.contrato.generales.bos;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.generales.daos.OpcionesContratoDAO;
import com.mx.dla.dda.contrato.generales.dtos.BundleReturn;
import com.mx.dla.dda.contrato.generales.dtos.CambioEstatusDTO;
import com.mx.dla.dda.contrato.generales.dtos.ProcesoPendienteDTO;
import com.mx.dla.dda.contrato.generales.enums.CatalogoTipo;
import com.mx.dla.dda.contrato.generales.enums.Estatus;
import com.mx.dla.dda.contrato.generales.enums.MensajeTexto;
import com.mx.dla.dda.contrato.generales.enums.TipoMensaje;
import com.mx.dla.global.bos.BaseBO;

@Component
public class OpcionesContratoBO extends BaseBO{
	
	@Autowired
	private OpcionesContratoDAO opcionesContratoDAO;
	
	
	public void insertaComponentesContrato(Long idContrato, List<Long> idsComponentes, CatalogoTipo tipo){
		
		Integer noTitulosEnServicio = null;
		
		for (Long idComponente: idsComponentes) {
			try{
				if(tipo.equals(CatalogoTipo.CATEGORIA)) {
					opcionesContratoDAO.insertarCategoria(idContrato, idComponente);
				}else if(tipo.equals(CatalogoTipo.SERVICIO)) {
					
					noTitulosEnServicio = opcionesContratoDAO.verificaPorcentajeTitulosEnServicio(idContrato, idComponente);
					if(noTitulosEnServicio == null) {
						opcionesContratoDAO.insertarServicio(idContrato, idComponente);
					}
					
				}else if(tipo.equals(CatalogoTipo.TERRITORIO)) {
					opcionesContratoDAO.insertarTerritorio(idContrato, idComponente);
				}else if(tipo.equals(CatalogoTipo.MEDIO)){
					opcionesContratoDAO.insertarMedioEntrega(idContrato, idComponente);
				}else if(tipo.equals(CatalogoTipo.FILIAL)){
					opcionesContratoDAO.insertarFilial(idContrato, idComponente);
				}else if(tipo.equals(CatalogoTipo.TYPE)){
					opcionesContratoDAO.insertarType(idContrato, idComponente);
				}
				
			}catch(Exception ex){
				logger.error("", ex);
			}
		}
	}
	
	public void registraTipoAmortizacion(Long idContrato, String tipoAmortizacion){
		
		try {
			opcionesContratoDAO.registraTipoAmortizacion(idContrato, tipoAmortizacion);
		} catch(Exception e) {
			logger.error("Error : ", e);
		}
	}

	public void eliminaComponentes(Long idContrato, CatalogoTipo tipo){
		try{
			
			if(tipo.equals(CatalogoTipo.CATEGORIA)) {
				opcionesContratoDAO.eliminarCategorias(idContrato);
			}else if(tipo.equals(CatalogoTipo.SERVICIO)) {
				opcionesContratoDAO.eliminarServicios(idContrato);
			}else if(tipo.equals(CatalogoTipo.TERRITORIO)) {
				opcionesContratoDAO.eliminarTerritorios(idContrato);
			}else if(tipo.equals(CatalogoTipo.MEDIO)){
				opcionesContratoDAO.eliminarMediosEntrega(idContrato);
			}else if(tipo.equals(CatalogoTipo.FILIAL)){
				opcionesContratoDAO.eliminarFiliales(idContrato);
			}else if(tipo.equals(CatalogoTipo.TYPE)){
				opcionesContratoDAO.eliminarTypes(idContrato);
			}else if(tipo.equals(CatalogoTipo.AREA)){
				opcionesContratoDAO.eliminarContratoArea(idContrato);
			}
			
		}catch(Exception ex){
			logger.error("", ex);
		}
	}
	
	public void actualizaTipoAmortizacion(Long idContrato, String tipoAmortizacion){
		
		try {
			opcionesContratoDAO.actualizaTipoAmortizacion(idContrato, tipoAmortizacion);
		} catch(Exception e) {
			logger.error("Error : ", e);
		}
	}
	
	public void actulizaEstatus(Long idEstatus, Long idContrato, String expediente){//modifica a 
		
		//String cabioEstatus = null;
		CambioEstatusDTO cambioEstatusDTO = new CambioEstatusDTO();
		
		try{
			
			opcionesContratoDAO.actualizaEstatus(idEstatus, idContrato);
			cambioEstatusDTO.setIdEstatus(idEstatus);
			cambioEstatusDTO.setIdContrato(idContrato);
			cambioEstatusDTO.setExpediente(expediente);
			cambioEstatusDTO.setFechaEstatus(new Date());
			opcionesContratoDAO.registraCambioEstatus(cambioEstatusDTO);
			/*VERSION ANTERIOR
			generalesDAO.actualizaEstatus(idEstatus, idContrato);
			cabioEstatus = generalesDAO.obtenerCambioEstatus(idContrato, idEstatus, expediente);
			if(cabioEstatus == null){
				
				cambioEstatusDTO.setIdEstatus(idEstatus);
				cambioEstatusDTO.setIdContrato(idContrato);
				cambioEstatusDTO.setExpediente(expediente);
				cambioEstatusDTO.setFechaEstatus(new Date());
				
				generalesDAO.registraCambioEstatus(cambioEstatusDTO);
			}*/
			
		}catch(Exception ex){
			logger.info("", ex);
		}
		
	}
	
	public boolean tieneFechaAutorizacion(Long idContrato) {
		boolean respuesta = false;
		
		Date fechaAutorizacion = null;
		
		try {
			
			fechaAutorizacion = opcionesContratoDAO.obtenerFechaAutorizacion(idContrato);
			
			if(fechaAutorizacion != null){
				respuesta = true;
			}
			
		} catch(Exception ex) {
			logger.error("Error : [{}]", ex);
		}
		
		return respuesta;
	}
	
	public void actualizaFechaAutorizacion(Date fechaAutorizacion, Long idContrato) {
		
		try{
			
			opcionesContratoDAO.actualizaFechaAutorizacion(fechaAutorizacion, idContrato);
		
		}catch (Exception ex) {
			logger.debug("Error : [{}]", ex);
		}
	}
	
	public void ponEnNullMesesPjeExclusivo(Long idContrato) {
		
		try {
			
			opcionesContratoDAO.ponEnNullMesesPjeExclusivo(idContrato);
			
		}catch(Exception ex) {
			logger.error("Error : [{}]", ex);
		}
		
	}
	
	public Long actualizaEstatusPadreContrato(Long idContrato, String expediente) {

		Long idPadre = null;
		Long estatusPadre = null;

		try {

			idPadre = opcionesContratoDAO.obtenerIdPadreContrato(idContrato);
			estatusPadre = opcionesContratoDAO.obtenerEstatusPadreContrato(idPadre);

			logger.debug("idPadre: {}", idPadre);
			logger.debug("estatusPadre: {}", estatusPadre);

			if (idContrato.longValue() != idPadre.longValue()) {
				logger.debug("paso evaluacion: idContrato ({}) vs idPadre ({})", idContrato.longValue(), idPadre.longValue());
				if (estatusPadre.longValue() == Estatus.Vigente.getValor().longValue()) {
					logger.debug("paso evaluacion: estatusPadre ({}) vs Estatus.Vigente ({})", estatusPadre.longValue(), Estatus.Vigente.getValor().longValue());
					actulizaEstatus(Estatus.Autorizado.getValor(), idPadre, expediente);
				}
			}

		}
		catch (Exception ex) {
			logger.error("Error : [{}]", ex);
		}

		return idPadre;
	}
	
	public void registraProcesoPendiente(Long idContrato, String clave, Integer estatus) {
		
		ProcesoPendienteDTO procesoPendiente = new ProcesoPendienteDTO();
		
		procesoPendiente.setClave(clave);
		procesoPendiente.setIdContrato(idContrato);
		procesoPendiente.setEstatus(estatus);
		
		try {
			
			opcionesContratoDAO.registraProcesoPendiente(procesoPendiente);
			
		}catch(Exception ex) {
			logger.error("Error : [{}]", ex);
		}
		
	}
	
	
	public boolean esContratoAmortizable(Long idContrato) {
		boolean respuesta = false;
		String valor = "";
		
		try {
			
			valor = opcionesContratoDAO.obtenerValorAmortizable(idContrato);
			
			if(valor.equals("SI")) {
				respuesta = true;
			}
			
		}catch(Exception ex) {
			logger.error("Error : [{}]", ex);
		}
		
		return respuesta;
	}
	
	public String obtenerNumeroContrato(Long idContrato) {
		String numeroContrato = "";
		try {
			
			numeroContrato = opcionesContratoDAO.obtenerNumeroContrato(idContrato);
			
		}catch(Exception ex) {
			logger.error("Erro : [{}]", ex);
		}
		
		return numeroContrato;
	}
	
	public boolean llamarAjustaAddendum(Long idContrato) {
		boolean respuesta = true;
		
		Map<String, Object> parametroSP = new HashMap<String, Object>();
		parametroSP.put("idContrato", idContrato);
		
		try {
			
			opcionesContratoDAO.llamarAjustaAddendum(parametroSP);
			
		}catch(Exception ex) {
			logger.debug("Fallo SP AjustaAddendum : [{}]", ex);
			respuesta = false;
		}
		
		return respuesta;
	}
	
	public boolean llamarReportePagos(Long idContrato) {
		boolean respuesta = true;
		
		Map<String, Object> parametroSP = new HashMap<String, Object>();
		parametroSP.put("idContrato", idContrato);
		
		try {
			
			opcionesContratoDAO.llamarReportePagos(parametroSP);
			
		}catch(Exception ex) {
			logger.debug("Fallo SP llamarReportePagos : [{}]", ex);
			respuesta = false;
		}
		
		return respuesta;
	}
	
	public boolean llamarAmortizacionInicial(Long idContrato) {
		boolean respuesta = true;
		
		Map<String, Object> parametroSP = new HashMap<String, Object>();
		parametroSP.put("idContrato", idContrato);
		
		try {
			
			opcionesContratoDAO.llamarAmortizacionInicial(parametroSP);
			
		}catch(Exception ex) {
			logger.debug("Fallo SP llamarAmortizacionInicial : [{}]", ex);
			respuesta = false;
		}
		
		return respuesta;
	}
	
	public boolean llamarAmortizacionCpv(Long idContrato) {
		boolean respuesta = true;
		
		Map<String, Object> parametroSP = new HashMap<String, Object>();
		parametroSP.put("idContrato", idContrato);
		
		try {
			
			opcionesContratoDAO.llamarAmortizacionCpv(parametroSP);
			
		}catch(Exception ex) {
			logger.debug("Fallo SP llamarAmortizacionInicial : [{}]", ex);
			respuesta = false;
		}
		
		return respuesta;
	}
	
	public BundleReturn cancelarContrato(Date fechaCancelacion, Long idContrato, String expedienteUsuario, Long tipoContrato){
		
		//logger.info("fc : [{}] -- tipoContrato : [{}]", fechaCancelacion, tipoContrato);
		
		BundleReturn respuesta = new BundleReturn();
		List<Long> idFacturas = null;
		
		respuesta.setCadena(MensajeTexto.CONTRATO_NO_CANCELADO.getTexto());
		respuesta.setNumero(TipoMensaje.ERROR.getValor());
		respuesta.setEstado(false);
		
		try{
			
			idFacturas = opcionesContratoDAO.obtenerIdFacturas(fechaCancelacion, idContrato);
			
			//logger.info("idFacturas size [{}]: ", idFacturas.size());
			
			if(idFacturas.size() == 0){
				
				respuesta.setCadena(MensajeTexto.CONTRATO_CANCELADO.getTexto());
				respuesta.setNumero(TipoMensaje.EXITO.getValor());
				respuesta.setEstado(true);
				
				actulizaEstatus(Estatus.Cancelado.getValor(), idContrato, expedienteUsuario);
				
				if(tipoContrato != 2)
					opcionesContratoDAO.eliminaDespuesFechaCancelacion(fechaCancelacion, idContrato);
				
				opcionesContratoDAO.actualizafechaCancelacion(fechaCancelacion, idContrato);
			}
			
		}catch(Exception ex) {
			logger.error("Error : [{}]", ex);
		}
		
		
		return respuesta;
	}
	
	public void insertaTotalTitulos(Long idContrato, Integer totalTitulos) {
		try {
			logger.info("Insertando Total Titulos");
			opcionesContratoDAO.insertaTotalTitulos(idContrato, totalTitulos);
		} catch (Exception ex) {
			logger.error("Error : [{}]", ex);
		}
	}
	
	public boolean validaTotalTitulos(Long idContrato) {
		Long idConQuery = null;
		boolean resp = false;
		try {
			logger.info("Valida Total Titulos");
			idConQuery = opcionesContratoDAO.validaTotalTitulos(idContrato);
			if(idConQuery != null)
				resp = true;
		} catch (Exception ex) {
			logger.error("Error : [{}]", ex);
		}
		
		return resp;
	}
	
	public void actualizaTotalTitulos(Long idContrato, Integer totalTitulos) {
		try {
			logger.info("Actualiza Total Titulos");
			opcionesContratoDAO.actulizaTotalTitulos(idContrato, totalTitulos);
		} catch (Exception ex) {
			logger.error("Error : [{}]", ex);
		}
	}
	
	public void actualizaEstadosBypassWorkflow(Long idContrato, String expediente){
		opcionesContratoDAO.actualizaEstatus(Estatus.Notificacion.getValor(), idContrato);
		opcionesContratoDAO.completaWorkflowContrato(idContrato, expediente);
	}

}
