package com.mx.dla.dda.contrato.minimum.bos;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.catalogos.dtos.FormatoDTO;
import com.mx.dla.dda.catalogos.dtos.PaisVentaDTO;
import com.mx.dla.dda.catalogos.dtos.ReleaseDTO;
import com.mx.dla.dda.contrato.minimum.daos.MinimunDAO;
import com.mx.dla.dda.contrato.minimum.dtos.MinimumPantallaDTO;
import com.mx.dla.dda.contrato.minimum.dtos.MinimunDTO;

@Service
public class MinimunBO {

	   final static Logger logger = Logger.getLogger(MinimunBO.class);
	   
	   private final DecimalFormat formateador = new DecimalFormat("###,###");
	   
	   @Autowired
	   private MinimunDAO minimunDAO;
	   
	   //idContrato + "-" + pais.getIdPais() + "-" + release.getIdRelease() + "-" + formato.getIdFormato() + id registro	    
	   public List<MinimumPantallaDTO> getValoresMinimun(Long idContrato, List<FormatoDTO> formatos, List<ReleaseDTO> releasses, List<PaisVentaDTO> paises)
	   {
		      List<MinimumPantallaDTO> valores    = new ArrayList<MinimumPantallaDTO>();
		      List<MinimumPantallaDTO> valoresAux = new ArrayList<MinimumPantallaDTO>();
		      List<MinimunDTO>         valoresBD  = new ArrayList<MinimunDTO>();
		      List<Long>               idPaises   = new ArrayList<Long>();
		      
		      //Se obtienen idpaises
		      for(PaisVentaDTO pais : paises)
		    	  idPaises.add(pais.getIdPais());
		      
		      valoresBD = minimunDAO.getMinimunsXPais(idPaises, idContrato);
		      
		      MinimumPantallaDTO encabezados = new MinimumPantallaDTO();
		      List<String> encabezadosValores = new ArrayList<String>();
		      encabezados.setPais("Países");
		      boolean listo = false;
		      
		      for(PaisVentaDTO pais : paises)
		      {
		    	  MinimumPantallaDTO minPantalla = new MinimumPantallaDTO();
		    	  minPantalla.setPais(pais.getDescripcionPais());
		    	  
		    	  List<String> idRegistros   = new ArrayList<String>();
		    	  List<String> valorPantalla = new ArrayList<String>();		    	  
		    	  
		    	  for(ReleaseDTO release : releasses)
		    	  {
		    		  for(FormatoDTO formato : formatos)
		    		  {		    	
		    			  if(!listo)
		    			     encabezadosValores.add(formato.getDescripcion());
		    			  
		    			  boolean encontrado = false;
		    			  
		    			  for(MinimunDTO minimun : valoresBD)
		    			  {		    				 
		    				 if(minimun.getIdPais().intValue()    == pais.getIdPais().intValue() && 
		    				    minimun.getIdRealese().intValue() == release.getIdRelease().intValue() &&
		    				    minimun.getIdFormato().intValue() == formato.getIdFormato().intValue())
		    				 {
		    					idRegistros.add(""+ idContrato + "-" + pais.getIdPais() + "-" + release.getIdRelease() + "-" + formato.getIdFormato() + "-" + minimun.getIdMinimun());
		    					valorPantalla.add(formateador.format(minimun.getMonto()));
		    					encontrado = true;		    					
		    					break;		    					
		    				 }		    				 
		    			 }
		    			 
		    			  if(!encontrado)
		    			  {
	    					 idRegistros.add(""+ idContrato + "-" + pais.getIdPais() + "-" + release.getIdRelease() + "-" + formato.getIdFormato() + "-" + 0);
	    					 valorPantalla.add("");	    					 
		    			  }		    			 
		    		  }		    		  
		    	  }
		    	  listo = true;

		    	  minPantalla.setIdRegistro(idRegistros);
		    	  minPantalla.setValores(valorPantalla);
		    	 
		    	  valoresAux.add(minPantalla);
		      }
		      encabezados.setValores(encabezadosValores);
		      valores.add(encabezados);
		      valores.addAll(valoresAux);
		      
		      return valores;
	   }
		   
	   public void actualizarInformacion(List<MinimunDTO> minimuns){
		      List<MinimunDTO> minimunsInsert = new ArrayList<MinimunDTO>();
		      List<MinimunDTO> minimunsAct    = new ArrayList<MinimunDTO>();
		      
		      for(MinimunDTO item : minimuns)
		      {   
		    	 
		          if(item.getIdMinimun().intValue() == 0 && item.getMonto() != null)
		    		  minimunsInsert.add(item);
		    	  else if(item.getIdMinimun().intValue() != 0 && item.getMonto() != null)
		    	      minimunsAct.add(item);
		      }
		      
		      if(!minimunsAct.isEmpty())
		    	  this.actualizarMinimun(minimunsAct);
		      
		      if(!minimunsInsert.isEmpty())
		    	  this.agregarMinimun(minimunsInsert);
	   }
	   
	   public void agregarMinimun(List<MinimunDTO> minimuns){
		   
		   for(MinimunDTO minimun : minimuns)
			   minimun.setIdMinimun(minimunDAO.getSecuenciaMinimun());			   			  
		   
		   minimunDAO.agregarMinimun(minimuns);
	   }
		
	   public void actualizarMinimun(List<MinimunDTO> minimuns){
		   
		   minimunDAO.actualizarMinimun(minimuns);
	   }
	   
}
