package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import java.io.IOException;

import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.ExcepcionesSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.MinimoGarantizadoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PrecioRentaDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PremiumDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.RevenueSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.SeccionesTerminos;
import com.mx.dla.global.bos.BaseBO;

@Service
public class TerminosPremier extends BaseBO{

	@Autowired
	private TerminosMinimos minimos;
	
	@Autowired
	private TerminosRelease release;
	
	@Autowired
	@Qualifier("precioPremier")
	private TerminosPrecio precio;
	
	@Autowired
	private TerminosRevenue revenue;
	
	@Autowired
	private TerminosExcepciones excepciones;
				
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public PremiumDTO obtenerPremium(Long idContrato)throws TransaccionException{
		PremiumDTO premium = new PremiumDTO();
		
		try
		{																		
			MinimoGarantizadoDTO minimo = minimos.obtenerMinimos(idContrato, SeccionesTerminos.RentaPremier.getDesc());			
			String[][] releasesDatos    = release.obtenerRelease(idContrato, SeccionesTerminos.RentaPremier.getDesc());
			PrecioRentaDTO   precioDTO  = precio.obtenerPrecio  (releasesDatos, idContrato, SeccionesTerminos.RentaPremier.getDesc());
			RevenueSeccionDTO revenueDTO = revenue.obtenerRevenue(idContrato, SeccionesTerminos.RentaPremier.getDesc(), releasesDatos);
			ExcepcionesSeccionDTO excepcionesDTO = excepciones.obtenerExcepciones(idContrato, SeccionesTerminos.RentaPremier.getDesc());
			
			premium.setMinimos(minimo);
			premium.setRelease(releasesDatos);
			premium.setPrecio(precioDTO);
			premium.setRevenue(revenueDTO);	
			premium.setExcepciones(excepcionesDTO);
			
		}catch(Exception e){
			new TransaccionException("Error al obtener terminos premium.", e);
		}								
		return premium;		
	}
	
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
	public void guardarPremium(PremiumDTO p, Long idContrato) throws JsonParseException, JsonMappingException, IOException, TransaccionException{
		
		try
		{			
			logger.debug(p.toString());
			precio.eliminarPaisesImpuestoEstatus(idContrato, SeccionesTerminos.RentaPremier.getDesc());
			precio.eliminarPreciosPremium(idContrato, SeccionesTerminos.RentaPremier.getDesc());
			revenue.eliminarRevenue(idContrato, SeccionesTerminos.RentaPremier.getDesc());
			
			minimos.guardarMinimos(p.getMinimos().getMinimosCateg(), p.getMinimos().getMinimosAnio(), p.getMinimos().getAnios(), p.getMinimos().getTipoMin(), SeccionesTerminos.RentaPremier.getDesc(), idContrato);
			release.guardarRelease(p.getRelease(), idContrato, SeccionesTerminos.RentaPremier.getDesc());						
		
			precio.actualizarPrecioAplica(idContrato, SeccionesTerminos.RentaPremier.getDesc(), p.getPrecio().getAplica());
			precio.actualizarPagoPpe(idContrato, SeccionesTerminos.RentaPremier.getDesc(), p.getPrecio().getPagoPPE());
	
			if(p.getPrecio().getAplica().intValue() == 1)
			   precio.guardarDatosPrecios(p.getPrecio(), release.getIds(), idContrato, SeccionesTerminos.RentaPremier.getDesc());			
				
			 revenue.guardarRevenue(idContrato, SeccionesTerminos.RentaPremier.getDesc(), release.getIds(), p.getRevenue());
			 excepciones.guardarExcepciones(idContrato, SeccionesTerminos.RentaPremier.getDesc(), p.getExcepciones());

		}
		catch(Exception e){
			new TransaccionException("Error al obtener terminos premium.", e);
		}
		
	}
	
}
