package com.mx.dla.dda.reporte.amortizacion.presupuesto.bo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.bos.BeanPopulator;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.reporte.amortizacion.presupuesto.dao.ReporteAmortVsPptoDAO;
import com.mx.dla.dda.reporte.amortizacion.presupuesto.dto.ReporteAmortizacionVsPresupuestoDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class ReporteAmortvsPptoBO extends BaseBO {
	@Autowired
	private ReporteAmortVsPptoDAO reporAmortPptodao;
	
	@Autowired
	private ExcelMapperContext excelMapperContext;
	
	@Autowired
	protected ExcelMapperTransform excelMapperTransform;
	
	@Autowired
	private BeanPopulator beanPopulator;
	
	public List<ReporteAmortizacionVsPresupuestoDTO> obtenReporteAmortPpto(Long mes, Long annio) throws Exception {

		List<ReporteAmortizacionVsPresupuestoDTO> reporteAmortPpto = null;

		try {
			
			reporteAmortPpto = reporAmortPptodao.obtenerReporteAmortPpto(mes,annio);
			
			logger.debug("obtenReporteAmortPpto - [{}]",reporteAmortPpto);
			
		} catch (Exception ex) {
			throw new TransaccionException("Error al obtener el Reporte de Amortizacion_Ppto - ", ex);
		}

		return reporteAmortPpto;
	}
	
	public byte [] descargaArchivoReporte(String mes) throws ExcelMapperException, IOException{
		 List<ReporteAmortizacionVsPresupuestoDTO> rowReporte =  new ArrayList<ReporteAmortizacionVsPresupuestoDTO>();
		
		try{
			 
			//rowReporte = reporAmortPptodao.obtenerReporteAmortPpto(mes);
			
			if(rowReporte == null || rowReporte.isEmpty())
			{
				rowReporte = new ArrayList<ReporteAmortizacionVsPresupuestoDTO>();
				rowReporte.add(beanPopulator.initObject(ReporteAmortizacionVsPresupuestoDTO.class));
			}			   											
			logger.debug("Descargar archivo Reporte... se han  obtenido [{}]",rowReporte.size());
			
		}catch(Exception ex){
			//throw new TransaccionException("Error al obtener el detalle de carga .", ex);
			logger.error("Error - descargaArchivoReporte. al buscar contenido para descargar archivo...");
		}
		
		byte[] fileExcel = excelMapperTransform.transformObjectToExcel(rowReporte,"reporteAmortizacion",ReporteAmortizacionVsPresupuestoDTO.class);
		logger.debug("Descargar archivo, se ha generado binario.");
		
		return fileExcel;
	}
	
	public byte[] descargaObjReporte(List<ReporteAmortizacionVsPresupuestoDTO> inforowReporte) throws TransaccionException{
		
		for(ReporteAmortizacionVsPresupuestoDTO c : inforowReporte){
			logger.debug("[{}]", c);
		}
		
		byte[] barchivo = null;
		ExcelMapper mapper = excelMapperContext.getExcelMapper("reporteAmortizacionPpto");
		
		try {
			
			barchivo = excelMapperTransform.transformObjectToExcel(inforowReporte, mapper, ReporteAmortizacionVsPresupuestoDTO.class);
			//System.out.println("mapper:"+mapper);
			
		}catch(Exception ex) {
			throw new TransaccionException("Error al obtener el excel.", ex);
	
		}
		
		return barchivo;		
		
	}

}
