package com.mx.dla.dda.reporte.configuracion.bos;

//import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.reporte.configuracion.daos.ConfiguracionReportesDAO;
import com.mx.dla.global.bos.BaseBO;

@Component
public class ConfiguracionReportesBO extends BaseBO{
	
	@Autowired
	private ConfiguracionReportesDAO configuracionReportesDAO;
	
	public void guardarConfiguracion(String claveReporte, Long idEstudio, String clavesColumnas ){
		
		logger.info("Parametros en ConfiguracionReportesBO claveReporte:" + claveReporte + ", id estudio: " + idEstudio + ", claves Columnas:" + clavesColumnas );
		
		try{
			logger.info("Se borra la configuracin que exista claveReporte:" + claveReporte + ", idEstudio:" + idEstudio );
			configuracionReportesDAO.eliminaConfiguracionReporte(claveReporte, idEstudio );
					
			String columnasClaves[] = clavesColumnas.split(",");
		    
			for (String columna: columnasClaves) {
				try{
					logger.info("BO COLUMNA :" + columna );
					
					configuracionReportesDAO.insertarConfiguracionReporte(claveReporte, idEstudio, columna);
									
				}catch(Exception ex){
					logger.error("", ex);
				}
			}
			
		}catch(Exception ex){
			logger.error("", ex);
		}
			
	}
	
	public String consultaConfiguracion(String claveReporte, Long idEstudio ){
		
			String columnasSeleccionadas = null;
			
			try {
				
					logger.info("Parametros en ConfiguracionReportesBO [consultaConfiguracion] claveReporte:" + claveReporte + ", id estudio: " + idEstudio );
					logger.info(configuracionReportesDAO.consultaConfiguracion(claveReporte, idEstudio ));
					
					columnasSeleccionadas = configuracionReportesDAO.consultaConfiguracion(claveReporte, idEstudio );
				
			}catch(Exception ex) {
				logger.error("Erro : [{}]", ex);
			}
			
			return columnasSeleccionadas;
		
	}
		
}