
package com.mx.dla.dda.contrato.generales.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.catalogos.dtos.CategoriaDTO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.catalogos.dtos.FilialesDTO;
import com.mx.dla.dda.catalogos.dtos.IndicadorDTO;
import com.mx.dla.dda.catalogos.dtos.MedioEntregaDTO;
import com.mx.dla.dda.catalogos.dtos.ServicioDTO;
import com.mx.dla.dda.catalogos.dtos.TerritorioDTO;
import com.mx.dla.dda.catalogos.dtos.TypesDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.bos.JustificacionBO;
import com.mx.dla.dda.contrato.common.dtos.JustificacionDTO;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.bos.PoblarGeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ApartadoDTO;
import com.mx.dla.dda.contrato.generales.dtos.AreaAutorizadorDTO;
import com.mx.dla.dda.contrato.generales.dtos.BotonDTO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.FechasDTO;
import com.mx.dla.dda.contrato.generales.dtos.NumeroTitulosTransDTO;
import com.mx.dla.dda.contrato.generales.enums.CatalogoTipo;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@Controller
@Scope("request")
public class GeneralesAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long tipoOperacion;
	private Long idContrato;
	private Long tipoContrato;
	private Long idContratoPadre;

	private List<EstudioDTO> estudios;
	private List<CategoriaDTO> categorias;
	private List<CategoriaDTO> categoriasActuales;
	private List<ServicioDTO> servicios;
	private List<ServicioDTO> serviciosActuales;
	private List<TerritorioDTO> territorios;
	private List<TerritorioDTO> territoriosActuales;
	private List<MedioEntregaDTO> mediosEntrega;
	private List<MedioEntregaDTO> mediosEntregaActuales;
	private List<FilialesDTO> filiales;
	private List<FilialesDTO> filialesActuales;
	private List<TypesDTO> types;
	private List<TypesDTO> typesActuales;
	private Long estatus;
	private String descripcionEstatus;
	private List<BotonDTO> botones;
	private String fechaInicio;
	private String fechaFin;
	private String fechaAutorizacion;
	private String fechaSAP;
	private String descripcionMovimiento;
	private String numeroContrato;
	private String annios;
	private String meses;
	private String fechaInicioPadre;
	private String descripcionEstudio;
	private String idSap;
	private String idContratoBv;
	private String statusSap;

	private Long siguienteAreaAutoriza;
	private List<AreaAutorizadorDTO> listaAreaAutorizador;

	private Integer ordenWF;
	private String expedienteUsuario;

	private List<JustificacionDTO> justificaciones;

	private boolean pintaBoton;

	private Integer tipoMensaje;
	private String mensajes;

	private List<ApartadoDTO> apartados;
	private Long idApartado;

	private boolean esEstudioVirtual;
	private List<EstudioDTO> estudiosOficiales;
	private Long estudioActualV;
	private boolean hayEstudiosConVirtual;

	private String fechaTitulosMin;
	private String fechaTitulosMax;

	private String valueTipoAmortizacion;

	private Integer puedeFinalizarRegistro;

	private List<IndicadorDTO> indicadores;
	private boolean indicadoresHabilitado;

	private Integer idAreaUsuario;
	private NumeroTitulosTransDTO noTituloTrans;
	private Integer noTitulos;

	private String perfil;

	@Autowired
	private PoblarGeneralesBO poblarGeneralesBO;

	@Autowired
	private GeneralesBO generalesBO;

	@Autowired
	private JustificacionBO justificacionBO;

	@Override
	@SuppressWarnings("unchecked")
	public String execute() throws TransaccionException {

		ContratoDTO contrato = null;
		UsuarioDTO usuario = null;

		setTipoContrato(poblarGeneralesBO.toLongTipoContrato(this.getSession().get("tipoContrato")));
		setIdContrato((Long) this.getSession().get("idContrato"));
		usuario = (UsuarioDTO) getSession().get("usuario");
		idAreaUsuario = usuario.getIdArea();
		// RFD agrega para uso en validacion de boton de workflow.
		setPerfil(usuario.getPerfil().getIdPerfil());
		// RFD -- Fin

		setPmn((String) getSession().get("pmn"));
		setPmnReturn((String) getSession().get("pmnReturn"));

		logger.info("tipoContrato : [{}] - idContrato : [{}] ", getTipoContrato(), getIdContrato());

		setPintaBoton(true);
		setEsEstudioVirtual(false);
		imprimirMensajeInfo(getTipoMensaje(), getMensajes());
		try {
			setFechaSAP(generalesBO.obtenerFechaSAP());
			setPuedeFinalizarRegistro(
					generalesBO.obtenerAreaPorExpediente(usuario.getExpediente()).getAutorizaContrato());

			if (idContrato == null || idContrato.equals("")) {

				setNumeroContrato("Pendiente");
				setEstudios(poblarGeneralesBO.obtenListaEstudios());
				setCategorias((List<CategoriaDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.CATEGORIA,
						tipoContrato));
				setServicios((List<ServicioDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.SERVICIO,
						tipoContrato));
				setTerritorios((List<TerritorioDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.TERRITORIO,
						tipoContrato));
				setMediosEntrega((List<MedioEntregaDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.MEDIO,
						tipoContrato));
				setFiliales(
						(List<FilialesDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.FILIAL, tipoContrato));
				setTypes((List<TypesDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.TYPE, tipoContrato));
				setEstatus(poblarGeneralesBO.establecerEstatusInicial());
				setDescripcionEstatus(poblarGeneralesBO.obtenDescripcionEstatus(getEstatus()));
				setBotones(poblarGeneralesBO.obtenerBotones(getEstatus()));
				setTipoOperacion(poblarGeneralesBO.establecerMovimientoInicial());
				setDescripcionMovimiento(poblarGeneralesBO.obtenerDescripcionMovimiento(getTipoOperacion()));
				setIndicadores(poblarGeneralesBO.obtenerIndicadores());
				setStatusSap("");
			} else {

				contrato = generalesBO.obtenContrato(idContrato);

				logger.info("contrato : [{}]", contrato);

				if (contrato != null) {

					logger.info("numero contrato: [{}] ", contrato.getNumeroContrato());

					setStatusSap(contrato.getStatusSap());
					setEstatus(contrato.getIdEstatus());
					setDescripcionEstatus(poblarGeneralesBO.obtenDescripcionEstatus(contrato.getIdEstatus()));
					setDescripcionMovimiento(
							poblarGeneralesBO.tipoOperacionPorNumeroContrato(contrato.getNumeroContrato()));
					setIndicadoresHabilitado(getDescripcionMovimiento().equals("Original") ? false : true);
					// rfd se aplica la evaluacion del tipo de opracion que se realizar, recordando
					// que el 2 es ademdum y 3 enmienda
					setIdSap(contrato.getIdSap());
					if (this.descripcionMovimiento.equals("Addendum"))
						if (this.idSap == null || this.idSap.isEmpty())
							setIdSap(" ");

					setTipoOperacion(contrato.getIdTipoMovimiento());
					setIdContratoPadre(contrato.getIdContratoPadre());
					setNumeroContrato(contrato.getNumeroContrato());
					setIdContrato(contrato.getIdContrato());
					setIdApartado(contrato.getIdApartado());
					setAnnios(contrato.getAnnios());
					setMeses(contrato.getMeses());
					setTipoContrato(contrato.getIdTipoContrato());
					setIdContratoBv(contrato.getIdContratoBv());

					if (getTipoContrato() == 2)
						noTituloTrans = poblarGeneralesBO.obtenerNumeroTitulosEnContratoTrans(idContrato);
					else
						noTitulos = poblarGeneralesBO.obtenerNumeroTitulosEnContratoSL(idContrato);

					setEstudios(poblarGeneralesBO.obtenerEstudioActual(contrato.getIdContrato()));

					setDescripcionEstudio(poblarGeneralesBO.obtenerDescripcionEstudio(contrato.getIdContrato()));

					setEstudioActualV(poblarGeneralesBO.obtenEstudioActualV(contrato.getIdContrato())); // para lo
																										// estudio
																										// virtual

					setFechaInicio(poblarGeneralesBO.formateaFecha(contrato.getFechaInicio()));
					setFechaFin(poblarGeneralesBO.formateaFecha(contrato.getFechaFin()));

					setFechaAutorizacion(poblarGeneralesBO.formateaFecha(contrato.getFechaAutorizacion()));

					setFechaTitulosMin(poblarGeneralesBO
							.formateaFecha(poblarGeneralesBO.obtenerFechaMinContratoTitulo(contrato.getIdContrato())));
					setFechaTitulosMax(poblarGeneralesBO
							.formateaFecha(poblarGeneralesBO.obtnerFechaMaxContratoTitulo(contrato.getIdContrato())));

					setCategorias((List<CategoriaDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.CATEGORIA,
							tipoContrato));
					setCategoriasActuales((List<CategoriaDTO>) poblarGeneralesBO
							.obtenerListaComponentesActuales(contrato.getIdContrato(), CatalogoTipo.CATEGORIA));
					setCategorias((List<CategoriaDTO>) poblarGeneralesBO.filtraRegistrosCatalogo(getCategorias(),
							getCategoriasActuales()));

					setServicios((List<ServicioDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.SERVICIO,
							tipoContrato));
					setServiciosActuales((List<ServicioDTO>) poblarGeneralesBO
							.obtenerListaComponentesActuales(contrato.getIdContrato(), CatalogoTipo.SERVICIO));
					setServicios((List<ServicioDTO>) poblarGeneralesBO.filtraRegistrosCatalogo(getServicios(),
							getServiciosActuales()));

					setTerritorios((List<TerritorioDTO>) poblarGeneralesBO
							.obtenListaComponentes(CatalogoTipo.TERRITORIO, tipoContrato));
					setTerritoriosActuales((List<TerritorioDTO>) poblarGeneralesBO
							.obtenerListaComponentesActuales(contrato.getIdContrato(), CatalogoTipo.TERRITORIO));
					setTerritorios((List<TerritorioDTO>) poblarGeneralesBO.filtraRegistrosCatalogo(getTerritorios(),
							getTerritoriosActuales()));

					setMediosEntrega((List<MedioEntregaDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.MEDIO,
							tipoContrato));
					setMediosEntregaActuales((List<MedioEntregaDTO>) poblarGeneralesBO
							.obtenerListaComponentesActuales(contrato.getIdContrato(), CatalogoTipo.MEDIO));
					setMediosEntrega((List<MedioEntregaDTO>) poblarGeneralesBO
							.filtraRegistrosCatalogo(getMediosEntrega(), getMediosEntregaActuales()));

					setFiliales((List<FilialesDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.FILIAL,
							tipoContrato));
					setFilialesActuales((List<FilialesDTO>) poblarGeneralesBO
							.obtenerListaComponentesActuales(contrato.getIdContrato(), CatalogoTipo.FILIAL));
					setFiliales((List<FilialesDTO>) poblarGeneralesBO.filtraRegistrosCatalogo(getFiliales(),
							getFilialesActuales()));

					setTypes((List<TypesDTO>) poblarGeneralesBO.obtenListaComponentes(CatalogoTipo.TYPE, tipoContrato));
					setTypesActuales((List<TypesDTO>) poblarGeneralesBO
							.obtenerListaComponentesActuales(contrato.getIdContrato(), CatalogoTipo.TYPE));
					setTypes(
							(List<TypesDTO>) poblarGeneralesBO.filtraRegistrosCatalogo(getTypes(), getTypesActuales()));

					setValueTipoAmortizacion(contrato.getTipoAmortizacion());

					setIndicadores(poblarGeneralesBO.obtenerIndicadoresConActual(contrato.getClaveIva()));

					setJustificaciones(justificacionBO.buscarJustificaciones(getIdContrato()));

					// la aparacin de los boton para autorizacin esta condicionada a la lista de
					// checks que estaran habilitados
					setListaAreaAutorizador(poblarGeneralesBO.habilitaSiguienteAutorizacion(
							poblarGeneralesBO.obtenAreaAutorizador(contrato.getIdContrato()), usuario.getExpediente()));

					setOrdenWF(poblarGeneralesBO.obtenerOrdenWF(listaAreaAutorizador));

					logger.info("Orden WF : [{}]", ordenWF);

					setBotones(poblarGeneralesBO.obtenerBotones(contrato.getIdEstatus()));

					setEsEstudioVirtual(generalesBO.esEstudioVirtual(contrato.getIdEstudio()));// para lo estudio
																								// virtual
					setEstudiosOficiales(poblarGeneralesBO.obtenerEstudioOficial());// para lo estudio virtual
					setHayEstudiosConVirtual(poblarGeneralesBO.hayContratosConVirtual(contrato.getIdEstudio(),
							contrato.getIdContrato()));// para lo estudio virtual

					setApartados(poblarGeneralesBO.obtenerApartados(contrato.getIdEstudio(), contrato.getIdApartado()));

					if (getTipoOperacion() != 1) {
						FechasDTO fechas = poblarGeneralesBO.obtenFechasContrato(contrato.getIdContratoOriginal());
						setFechaInicioPadre(poblarGeneralesBO.formateaFecha(fechas.getInicio()));
					}

					getSession().put("idContrato", contrato.getIdContrato());
					getSession().put("numContrato", contrato.getNumeroContrato());
					getSession().put("estudio", estudios.get(0).getDescripcionEstudio());

				} else {
					logger.info("EL contrato no existe");
				}
			}
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

	public String _metodo() {

		return "OK";
	}

	public void imprimirMensajeInfo(Integer tipoMensaje, String mensajes) { // mensajes puede tener una o mas cadenas de
																			// errores

		String[] mensajesError;

		if (tipoMensaje != null && mensajes != null) {

			mensajesError = mensajes.split("_");

			for (int i = 0; i < mensajesError.length; i++) {
				if (tipoMensaje == 1) {
					addActionMessage(mensajesError[i]);
				} else {
					addActionError(mensajesError[i]);
				}
			}

		}
	}

}
