package com.mx.dla.dda.contrato.condicionesLicense.constants;

import com.mx.dla.dda.catalogos.dtos.Catalogable;


public enum TipoAnio implements Catalogable{
	CALENDARIO("CALENDARIO","Calendario"),
	CONTRACTUAL("CONTRACTUAL","Contractual"),
;
	
	private String type;
	
	private String desc;
	
	TipoAnio(String type , String desc)
	{
		this.type = type;
		this.desc = desc;
	}
	
	public String getDesc() {
		return desc;
	}
	public String getType() {
		return type;
	}
	
	public static TipoAnio parse(String tipo)
	{
		TipoAnio [] values = TipoAnio.values();
		TipoAnio target = null;
		for(TipoAnio t : values)
		{
			if(t.getType().equals(tipo))
			{
				target = t;
				break;
			}
		}
		return target;
		
	}

	@Override
	public String getValue() {
		return type;
	}
}
