package com.mx.dla.dda.contrato.deal.actions;

import java.sql.SQLException;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.deal.bos.DealBO;
import com.mx.dla.dda.contrato.deal.dtos.DealDTO;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.opensymphony.xwork2.Action;

public class ContratoDealAction extends BaseContratoAction {
	
	private static final long serialVersionUID = 1L;

	private DealDTO deal = new DealDTO();
	private Long estadoCto;

	@Autowired
	private DealBO dealBO;
	
	@Autowired
	private GeneralesBO generalesBO;

	public String load() {
		try {
			Long idContrato = (Long)this.getSession().get("idContrato");
			
			deal.setIdContrato(idContrato);
			this.setIdContrato(idContrato);
			buscarJustificaciones();

			logger.info("dealDTO Before load: " + deal);

			deal = dealBO.cargaInformacionDeal(deal);

			logger.info("dealDTO After load: " + deal);
			
			ContratoDTO cto = generalesBO.obtenContrato(this.getIdContrato());
			this.estadoCto = cto.getIdEstatus();

		} catch (ResultMapException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error en ["+this.getClass()+"]. Error:"+e);
		} catch (PersistenceException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error en ["+this.getClass()+"]. Error:"+e);
		} catch (TransaccionException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error en ["+this.getClass()+"]. Error:"+e);
		} catch (SQLException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error en ["+this.getClass()+"]. Error:"+e);
		}

		return Action.SUCCESS;
	}

	public String save() {

		logger.info("dealDTO Before update: " + deal);
		try {

			this.setIdContrato(deal.getIdContrato());

			dealBO.actualizaInformacionDeal(deal);

			logger.info("dealDTO After update: " + deal);

			if (getJustificacion() != null && !"".equals(getJustificacion())) {
				guardarJustificacion();
				setJustificacion("");
			}
			
			buscarJustificaciones();
			
			ContratoDTO cto = generalesBO.obtenContrato(this.getIdContrato());
			this.estadoCto = cto.getIdEstatus();
			
			addActionMessage("La informacion se ha guardado con exito");


		} catch (ResultMapException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error en ["+this.getClass()+"]. Error:"+e);
		} catch (PersistenceException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error en ["+this.getClass()+"]. Error:"+e);
		} catch (TransaccionException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error en ["+this.getClass()+"]. Error:"+e);
		} catch (SQLException e) {
			addActionError("Ha ocurrido un error.");
			logger.error("Error en ["+this.getClass()+"]. Error:"+e);
		}

		return Action.SUCCESS;
	}

	public DealDTO getDeal() {
		return deal;
	}

	public void setDeal(DealDTO deal) {
		this.deal = deal;
	}

	public Long getEstadoCto() {
		return estadoCto;
	}

}
