var idEstudio;

$(document).ready(
	function() {
		inicializarBotones();
		$('#fecha').datepicker({
		changeYear: false,
	    changeMonth: false,
	    dateFormat: "yy/mm",
	});
	}
);

function inicial(){
	limpiarTabla();
	realizaConsulta();
	$("table thead tr").addClass("encabezado");
}

function inicializarBotones(){
	$("#botonConsultar").click(function()  
	{		
		var fecha		= $("#fecha").val();
		var estudio		= $("#estudio").val();
		if ((typeof fecha === 'string' && fecha.length === 0) || (typeof estudio === 'string' && estudio.length === 0)) {
		  showError("Debes seleccionar una fecha y un estudio.");
		} else {
		  inicial();
		}		
	});
	
	$("#generarExcel").click(function()  
	{		
		if ((typeof fecha === 'string' && fecha.length === 0) || (typeof estudio === 'string' && estudio.length === 0)) {
		  showError("Debes seleccionar una fecha y un estudio.");
		} else {
		  var url = contextPath +'/reporte/reportesTransacciones/reporteTransaccionesGeneralesExcel.action?fecha=' + $("#fecha").val() + '&estudio='+ $("#estudio").val() ;
			window.open(url);
		}		
	});
	
	$("#cerrar").click(function()  
	{		
		callActionAjax("/reporte/reportesTransacciones/cerrar", "", procesaRespuestaCierre);
		showMessage("Se cerro el mes ");
	});
	
	$("#reabrir").click(function()  
	{		
		callActionAjax("/reporte/reportesTransacciones/reabrir", "", procesaRespuestaCierre);		
	});
}

function limpiarTabla(){	
	$('#divTablaIn').remove();
	var div = '<div id="divTablaIn"></div>';
	$('#divTablaExt').append(div);
	var tabla = $("<table class='table table-striped'/>").attr('id',"cataEstudio");       
	$("#divTablaIn").append(tabla);	
}

function realizaConsulta(){				
	// Obtener numero de menu
	var menu        = $("#pmn").val();
	var menuRegreso = $("#pmnReturn").val();
	var fecha		= $("#fecha").val();
	var estudio		= $("#estudio").val();
	var jsonString = '{"fecha" : "'+ fecha + '", "estudio" : "' + estudio + '"}';
	var stringJson = JSON.parse(jsonString);
	var namespace = "/reporte/reportesTransacciones/";
    var rowId=null;
    var oTable=null;
     oTable=$('#cataEstudio').dataTable({		    
	   "bAutoWidth": false,
		"oLanguage":{	"sProcessing":     "Procesando...",
						"sLengthMenu":     "Mostrar _MENU_ registros",
						"sZeroRecords":    "Sin eventos encontrados",
						"sEmptyTable":     "Sin eventos encontrados",
						"sInfo":           "Mostrando  _START_ al _END_ de  _TOTAL_ ",
						"sInfoEmpty":      "0 registros",
						"sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
						"sSearch":         "Buscar:",
						"sInfoThousands":  ",",
						"sLoadingRecords": "Cargando...",
						"oPaginate": {
							"sFirst":    "Primero",
				        	"sLast":     "&Uacute;ltimo",
				        	"sNext":     "Siguiente",
				        	"sPrevious": "Anterior"
				    	}
				},
		"iDisplayLength": 10,
		"bInfo"     : false,
		"bFilter"   : true,
		"bSort"     : false,
		"bPaginate" :true,
		"sPaginationType" : "full_numbers",
		"aaSorting": [],
		ajax: {
            url: 'generarReporte',
            'data' : stringJson,
            type: 'POST',
        },
		"sAjaxSource": "",
		"sAjaxDataProp": "", 
	    "aoColumns": [
						{"sTitle":"Pais", 					"mDataProp":"pais",				"bSearchable": true, sWidth : "50px"},
						{"sTitle":"Titulo", 				"mDataProp":"titulo",			"bSearchable": true, sWidth : "100px"},
						{"sTitle":"Precio", 				"mDataProp":"precio",			"bSearchable": true, sWidth : "50px"},
						{"sTitle":"Precio Neto", 			"mDataProp":"precioNeto",		"bSearchable": true, sWidth : "50px"},
						{"sTitle":"Cantidad", 				"mDataProp":"cantidad",			"bSearchable": true, sWidth : "50px"},
						{"sTitle":"Precio Total",			"mDataProp":"precioTotal",		"bSearchable": true, sWidth : "50px"},
						{"sTitle":"Precio USD",				"mDataProp":"precioUsd",		"bSearchable": true, sWidth : "50px"},
						{"sTitle":"Precio USD - RV",		"mDataProp":"precioUsdRv",		"bSearchable": true, sWidth : "50px"}
	          			],
	    		        'fnRowCallback': function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
	    		        	$('td:eq(0)', nRow).html(aData["pais"]);
	    		        	$('td:eq(1)', nRow).html(aData["titulo"]);
	    		        	$('td:eq(2)', nRow).html(aData["precio"]);
	    		        	$('td:eq(3)', nRow).html(aData["precioNeto"]);
	    		        	$('td:eq(4)', nRow).html(aData["cantidad"]);
	    		        	$('td:eq(5)', nRow).html(aData["precioTotal"]);
	    		        	$('td:eq(6)', nRow).html(aData["precioUsd"]);
	    		        	$('td:eq(7)', nRow).html(aData["precioUsdRv"]);
	   		       		}
		});
     
}

function validarAgregar(){
	
	$("#forma").validate(
		      {
		        rules: 
		        {
		        	nombreEstudio: 
		          {
		            required: true,
		            maxlength: 50,
		            regex:"^[a-zA-Z0-9 ]+$"
		          }
		        },
		        messages: 
		        {
		        	nombreEstudio: 
		          {
		            required: "Nombre del Estudio es obligatorio.",
		            maxlength: "Nombre no debe exceder 50 caracteres",
		            regex: "Nombre debe ser con caracteres alfanumericos"
		          }
		        }
	});
	
	$.validator.addMethod("regex",function(value,element,regexp){
	      var re= new RegExp(regexp);
	      return this.optional(element) || re.test(value);
	},"Only Characters from A-z");
}

function eliminar(id){
	if(confirm('¿Esta seguro de borrar este registro?')){
		var jsonString = '{"idExcepcion" : "' + id + '"}';
		var stringJson = JSON.parse(jsonString);
		callActionAjax("/catalogos/excepciones/eliminaExcepcion", stringJson, procesaRespuestaActualiza);
	}
}

function regreso(){	
	var menu = $("#pmn").val();
	if(menu == '' || menu == null || menu == undefined)
		menu = 213;
	window.location.href = contextPath + "/catalogos/excepciones/index.action?pmn=" + menu;
}

function actualizaExcepcion(idExcepcio) {	
	idExcepcion = idExcepcio;
	llamaObtenExcepcion(idExcepcion);
}

function llamaObtenExcepcion(idExcepcion) {
	var jsonString = '{"idExcepcion" : "'+ idExcepcion +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/excepciones/llamaObtenExcepcion", stringJson, procesaRespuestaObtenEstudio);
}

function procesaRespuestaObtenEstudio(jsonData) {
	var exc = jsonData.excepcion;
	var stdios = jsonData.estudiosTrans;
	$('#titulo').val(exc.titulo);
	$('#revenueShare').val(exc.revenueShare);
	$('#fechaInicio').val(exc.fechaInicio);
	$('#fechaFin').val(exc.fechaFin);
	
	$('#nombreEstudio').children().remove();
	
	var option;
	for(var i = 0; i < stdios.length; i++){
		std = stdios[i];
		
		if(exc.estudio == std.idEstudio) {
			$('#nombreEstudio').append('<option value="'+ std.idEstudio +'" selected> '+ std.nombre +' </option>');
		}else {
			$('#nombreEstudio').append('<option value="'+ std.idEstudio +'"> '+ std.nombre +' </option>');
		}						
	}
}

function llamaActualizaEstudio() {
	
	var nombre = $('#nombreEstudio').val();
	var titulo = $('#titulo').val();
	var revenue = $('#revenueShare').val();
	var inicio = $('#fechaInicio').val();
	var fin = $('#fechaFin').val();
	var jsonString = '{"idExcepcion" : "'+ idExcepcion + '", "nombreEstudio" : "' + nombre + '", "titulo" : "' + titulo 
		+ '", "revenueShare" : "' + revenue + '", "fechaInicio" : "' + inicio + '", "fechaFin" : "' + fin +'"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax( "/catalogos/excepciones/llamaActualizaExcepcion", stringJson, procesaRespuestaActualiza);

}

function procesaRespuestaActualiza(jsonData) {
	
	var seRepite = jsonData.seRepiteSigla;
	
	$('#modalAgregaActualiza').modal('hide');
	
	if(!seRepite) {
		showMessage("Actualizado con exito");
	}else {
		showError("La sigla se repite en otro Estudio.");
	}
	
	inicial();	
}

function procesaRespuestaCierre(jsonData) {
	showMessage("Se actualizaron las fechas exitosamente");
}


function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         showError("Problemas al enviar los datos.");
	     }
	 });	
}