package com.mx.dla.dda.contrato.notasDeCredito.bos;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.notasDeCredito.daos.NotasDeCreditoDAO;
import com.mx.dla.dda.contrato.notasDeCredito.dtos.NotaDeCreditoDbDTO;

@Service
public class NotasDeCreditoBO {

	@Autowired
	private NotasDeCreditoDAO	 notasDeCreditoDAO;

	@Autowired
	private GeneralesDAO generalesDAO;
	
	public List<NotaDeCreditoDbDTO> regresaNotasDeCredito(Long idContrato){
		List<NotaDeCreditoDbDTO> source = new ArrayList<NotaDeCreditoDbDTO>();
		
		ContratoDTO contrato = generalesDAO.obtenerContrato(idContrato);
		
		source = notasDeCreditoDAO.regresaNotasDeCredito(contrato.getIdContratoOriginal());
		
		return source;
	}
}
