package com.mx.dla.dda.contrato.generales.enums;

public enum MensajeTexto {
	
	CONTRATO_REGISTRADO("Contrato registrado exitosamente."),
	CONTRATO_ACTUALIZADO("Contrato actualizado exitosamente."),
	CONTRATO_REINICIADO("Contrato reiniciado."), 
	CONTRATO_SUSPENDIDO("Contrato suspendido."), 
	CONTRATO_ACTIVADO("Contrato activado."),
	CONTRATO_CANCELADO("Contrato cancelado."),
	CONTRATO_NO_CANCELADO("Contrato no cancelado, tiene facturas asociadas."),
	CONTRATO_RECHAZADO("Contrato rechazado."),
	ESTUDIO_MODIFICADO("Estudio modificado."), 
	TIEMPO_AGOTADO("Tiempo agotado."),
	LLAMADA_EXITOSA("Llamada a servicio exitosa."), 
	LLAMADA_NO_EXITOSA("Llamada a servicio no exitosa."), 
	CONTRATO_NO_FINALIZADO("Contrato no finalizado."), 
	CONTRATO_FINALIZADO("Contrato finalizado exitosamente."), 
	CONTRATO_EXCEDE_PRESUPUESTO("Contrato excede el presupuesto."), 
	CONTRATO_NO_TIENE_APARTADOS("El contrato no tiene asignado un apartado."),
	CONTRATO_CON_SINSUBNUMERO("El contrato tiene títulos que no pueden bajar de precio."),
	CONTRATO_NO_TIENE_TITULOS("El contrato no tiene títulos asignados."), 
	CONTRATO_NO_TIENE_CONDICIONES_PAGO("El contrato no tiene definido las condiciones de pago en Fees."), 
	CONTRATO_NO_TIENE_FILIALES("El contrato no tiene filiales asignadas en Deal Detail."),
	CONTRATO_NO_TIENE_TERMINOS("El contrato no tiene configurados los términos comerciales."),
	CONTRATO_NO_TIENE_DOCUMENTOS("El contrato debe tener un documento asociado."),
	CONTRATO_NO_ESTUDIO_OFICIAL("El contrato no esta asociado a un estudio reconocido por SAP."),
	CONTRATO_NO_CUMPLE_MINIMOS("El contrato no cumple con los mínimos de selección especificados."),
	CONTRATO_NO_TITULOS_ESPECIFICADOS("El contrato no contiene el total de títulos especificados."),
	AUTORIZACION_REGISTRADA("Autorización registrada."), 
	AUTORIZACION_NO_REGISTRADA("La autorización no pudo ser registrada."),
	AUTORIZACION_VERIFICA("La autorización no puede ser registrada, verifique la lista de destinatarios."),
	PENDIENTE_POR_AUTORIZAR("Tiene pendiente por autorizar  "),
	EMAIL_SUBJECT_AUTORIZACION("DDA - Notificaci&oacute;n de autorizaci&oacute;n del contrato: "), 
	EMAIL_SUBJECT_NO_AUTORIZACION("DDA - Notificaci&oacute;n de no autorizaci&oacute;n del contrato: "),
	NOTIFICACION_FINALIZO_REGISTRO("Se notificó la finalización de registro."),
	NOTIFICACION_NO_FINALIZO_REGISTRO("No se pudo enviar la notificación por correo. "),
	RECHAZO_NO_NOTIFICADO("El rechazo no pudo ser registrado."),
	RECHAZO_NOTIFICADO("El rechazo se realizo correctamente."),
	ERROR_AL_CARGAR("El archivo no cumple con el formato."),
	ETIQUETE_FINALIA_REGISTRO("Se ha <b>finalizado</b> el registro del contrato: <b>nctoremp</b>, <br/>con las siguientes caracter&iacute;sticas:"),
	ETIQUETA_AUTORIZACION_WF("Se ha <b>autorizado</b> el contrato: <b>nctoremp</b>, <br/>con las siguientes caracter&iacute;sticas:"),
	ETIQUETA_FINALIZA_AUTORIZACION_WF("Se ha finalizado el proceso de <b>autorizaci&oacute;n</b> del contrato: <b>nctoremp</b>, <br/>con las siguientes caracter&iacute;sticas:"),
	ETIQUETA_RECHAZO_AUTORIZACION_WF("El &aacute;rea de sarea <b>no ha autorizado</b> el contrato: <b>nctoremp</b>."),
	ETIQUETA_CREACION_CONTRATO("Se ha creado el contrato: <b>nctoremp</b>."),
	CONTRATO_COSTO_NO_DISMINUIR("El contrato no puede disminuir su costo"),
	ERROR_CALCULO_MINIMO_GARANTIZADO("Existen errores en el calculo del mínimo garantizado");
	
	private String texto;
	
	MensajeTexto(String texto) {
		this.texto = texto;
	}
	
	public String getTexto() {
		return texto;
	}
	
	public static MensajeTexto parse (String texto){
		MensajeTexto [] values = MensajeTexto.values();
		MensajeTexto target = null;
		
		for(MensajeTexto t : values) {
			if(t.getTexto().equals(texto)){
				target = t;
				break;
			}
		}
		
		return target;
	}

}
