package com.mx.dla.dda.contrato.transaccion.terminos.actions;

import java.io.IOException;
import java.sql.SQLException;

import org.apache.ibatis.executor.result.ResultMapException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosPremium;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosTransaccionBO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PremiumDTO;
import com.opensymphony.xwork2.Action;

public class TerminosPremiumAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	@Autowired
	private TerminosPremium service;

	@Autowired
	private TerminosTransaccionBO comun;

	private PremiumDTO premium;
	private String mensaje;
	private String error;
	private Long idContrato;

	public String obtener() {
		try {
			premium = service.obtenerPremium((Long) this.getSession().get("idContrato"));

		} catch (TransaccionException e) {
			error = e.getMessage();
		} catch (ResultMapException e) {
			error = e.getMessage();
		} catch (SQLException e) {
			error = e.getMessage();
		}
		return Action.SUCCESS;
	}

	public String guardar() {
		try {
			comun.guardarDatosComun(premium.getComun(), this.idContrato);
			service.guardarPremium(premium, this.idContrato);
			comun.calculaPagoMinGarantizado(this.idContrato);

		} catch (TransaccionException e) {
			error = e.getMessage();
		} catch (JsonParseException e) {
			error = "Error al guardar los Terminos Premium";
			logger.error("Error {}", e);
		} catch (JsonMappingException e) {
			error = "Error al guardar los Terminos Premium";
			logger.error("Error {}", e);
		} catch (IOException e) {
			error = "Error al guardar los Terminos Premium";
			logger.error("Error {}", e);
		}
		return Action.SUCCESS;
	}

	public PremiumDTO getPremium() {
		return premium;
	}

	public String getMensaje() {
		return mensaje;
	}

	public String getError() {
		return error;
	}

	public void setPremium(PremiumDTO premium) {
		this.premium = premium;
	}

	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}
}