package com.mx.dla.admin.usuarios.perfil.actions;

import java.sql.SQLException;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.admin.usuarios.perfil.bos.UsuarioPerfilBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class UsuarioPerfilAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	public UsuarioDTO usuario;
	public String correoElectronico;
	public String contrasena;
	public String operacion;
	public boolean exito;

	@Autowired
	private UsuarioPerfilBO usuarioPerfilBO;

	@Override
	public String execute() {
		setUsuario((UsuarioDTO) this.getSession().get("usuario"));
		this.getSession().put("pmn", null);
		this.getSession().put("pmnReturn", null);
		return SUCCESS;
	}

	public String actulizaPropiedadesUsuario() throws TransaccionException {
		setUsuario((UsuarioDTO) this.getSession().get("usuario"));

		try {
			setExito(usuarioPerfilBO.actulizaPropiedadUsuario(usuario.getExpediente(), correoElectronico, contrasena,
					operacion));
			setUsuario(usuarioPerfilBO.obtenerUsuario(usuario.getExpediente()));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (PersistenceException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		this.getSession().put("usuario", usuario);
		return SUCCESS;
	}

	public void setUsuario(UsuarioDTO usuario) {
		this.usuario = usuario;
	}

	public UsuarioDTO getUsuario() {
		return usuario;
	}

	public void setCorreoElectronico(String correoElectronico) {
		this.correoElectronico = correoElectronico;
	}

	public String getCorreoElectronico() {
		return correoElectronico;
	}

	public void setContrasena(String contrasena) {
		this.contrasena = contrasena;
	}

	public String getContrasena() {
		return contrasena;
	}

	public void setOperacion(String operacion) {
		this.operacion = operacion;
	}

	public String getOperacion() {
		return operacion;
	}

	public void setExito(boolean exito) {
		this.exito = exito;
	}

	public boolean getExito() {
		return exito;
	}
}
