package com.mx.dla.configuration;

import javax.servlet.ServletContext;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.mx.dla.admin.daos.UsuarioDAO;
import com.mx.dla.admin.dtos.UsuarioDTO;

@Component
@WebListener
public class SessionListener implements HttpSessionListener {

	private UsuarioDAO usuarioDAO;

	protected Logger logger = LoggerFactory.getLogger("app");

	@Override
	public void sessionCreated(HttpSessionEvent event) {

	}

	@Override
	public void sessionDestroyed(HttpSessionEvent event) {
		ServletContext servletContext = event.getSession().getServletContext();
		usuarioDAO = WebApplicationContextUtils.getRequiredWebApplicationContext(servletContext)
				.getBean(UsuarioDAO.class);

		UsuarioDTO usuario = (UsuarioDTO) event.getSession().getAttribute("usuario");
		
		if (usuario != null) {
			String ipAdress = event.getSession().getAttribute("ipAdress").toString();
			String userAgent = event.getSession().getAttribute("userAgent").toString();
			logger.info("Sesin destruida: " + usuario.getExpediente());
			usuarioDAO.actualizaEstadoSesion(1, usuario.getExpediente());
			usuarioDAO.insertaBitacora("LogOut Exitoso Destroy", usuario.getExpediente(), ipAdress, userAgent);
		}
		event.getSession().invalidate();
	}
}
