package com.mx.dla.dda.contrato.transaccion.titulos.bos;

import java.sql.SQLException;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.FechasDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.bos.BaseBO;

@Component
public class TitulosBussinesTranBO extends BaseBO {

	@Autowired
	protected GeneralesDAO generalesDAO;

	public ContratoDTO calculaFechasInicioFinValidacion(Long idCtoOri)
			throws ResultMapException, SQLException, TransaccionException {
		ContratoDTO cto = null;
		try {
			FechasDTO fechas = generalesDAO.obtenerFechasMaximaMinimaDeContratosPorContratoOriginal(idCtoOri);
			cto = new ContratoDTO();
			cto.setFechaInicio(fechas.getInicio());
			cto.setFechaFin(fechas.getFin());
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}
		return cto;
	}
}
