package com.mx.dla.dda.contrato.minimoseleccion.actions;

import java.sql.SQLException;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

@Controller
@Scope("request")
public class PrecioAnualMinimoAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private Long idContrato;
	private String tipoPago;
	private Long idContratoPago;
	private Integer annio;
	private Long idPagoCategoria;
	private Long idMinimoSeleccion;
	private Integer noTitulos;
	private String precioAnual;
	private String minimo;

	@Autowired
	MinimoSeleccionBO minimoSeleccionBO;

	public String execute() throws TransaccionException {
		String precio_minimo = null;
		try {
			precio_minimo = minimoSeleccionBO.obtenPrecioAnualAndMinimo(tipoPago, idContratoPago, annio,
					idPagoCategoria, noTitulos, idContrato);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		String[] precio_minimo_array = precio_minimo.split("_");
		setPrecioAnual(precio_minimo_array[0]);
		setMinimo(precio_minimo_array[1]);
		return SUCCESS;
	}

	public Long getIdContrato() {
		return idContrato;
	}

	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}

	public void setTipoPago(String tipoPago) {
		this.tipoPago = tipoPago;
	}

	public String getTipoPago() {
		return tipoPago;
	}

	public Long getIdContratoPago() {
		return idContratoPago;
	}

	public void setIdContratoPago(Long idContratoPago) {
		this.idContratoPago = idContratoPago;
	}

	public Integer getAnnio() {
		return annio;
	}

	public void setAnnio(Integer annio) {
		this.annio = annio;
	}

	public Long getIdPagoCategoria() {
		return idPagoCategoria;
	}

	public void setIdPagoCategoria(Long idPagoCategoria) {
		this.idPagoCategoria = idPagoCategoria;
	}

	public Long getIdMinimoSeleccion() {
		return idMinimoSeleccion;
	}

	public void setIdMinimoSeleccion(Long idMinimoSeleccion) {
		this.idMinimoSeleccion = idMinimoSeleccion;
	}

	public void setNoTitulos(Integer noTitulos) {
		this.noTitulos = noTitulos;
	}

	public Integer getNoTitulos() {
		return noTitulos;
	}

	public String getPrecioAnual() {
		return precioAnual;
	}

	public void setPrecioAnual(String precioAnual) {
		this.precioAnual = precioAnual;
	}

	public String getMinimo() {
		return minimo;
	}

	public void setMinimo(String minimo) {
		this.minimo = minimo;
	}

}
