package com.mx.dla.dda.reporte.amortizacion.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.reporte.amortizacion.bos.ReporteExcelAmortizacionBO;

public class ExcelAmortizacionAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private String fecha;

	private Long idEstudio;

	private InputStream fileInputStream;

	@Autowired
	ReporteExcelAmortizacionBO reporteExcelAmortizacionBO;

	@Override
	public String execute() {
		return SUCCESS;
	}

	public String descargarArchivo() throws TransaccionException {

		byte[] bytes = null;
		try {
			bytes = reporteExcelAmortizacionBO.generaReporteAmortizacion(idEstudio, fecha);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (ExcelMapperException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IOException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		fileInputStream = new ByteArrayInputStream(bytes);

		return SUCCESS;
	}

	public String descargarArchivoSAP() throws TransaccionException {

		try {
			byte[] bytes = reporteExcelAmortizacionBO.generaReporteAmortizacionSAP(idEstudio, fecha);
			fileInputStream = new ByteArrayInputStream(bytes);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (ExcelMapperException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IOException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String descargarArchivoSAPDLA() throws TransaccionException {

		try {
			byte[] bytes = reporteExcelAmortizacionBO.generaReporteAmortizacionSAPDLA(idEstudio, fecha);
			fileInputStream = new ByteArrayInputStream(bytes);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String getFecha() {
		return fecha;
	}

	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

}
