
var reporteRevenueYSplitsController = function($scope, $filter, utileriasService) {

	$scope.tipoReporte = null;
	$scope.tabla = null;
	$scope.header = null;
	$scope.columnCfg = null;
	$scope.estudios = [];
	$scope.estudio = null;
	$scope.muestraInformacion = null;

	var date = moment().subtract(1, 'months').format('MM/YYYY');

	$scope.fecha = date;

	$('#mes').datepicker({ dateFormat: 'mm/yy' });


	utileriasService.actionCall('/reporte/revenuesplits/obtenerEstudios.action', {}).then(function(data) {

		if (data.errorMensaje != null)
			showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
		else {
			$scope.estudios = data.estudios;
		}
	},
		function(error) {
			showError("Ha ocurrido el siguiente error: " + error);
		});


	$scope.muestraReporte = function(fecha, tipoAbono, idEstudio) {
		if (!fecha)
			showError("Favor de elegir una fecha para el reporte");
		else if (!tipoAbono)
			showError("Favor de elegir un tipo de abono");
		else if (!idEstudio)
			showError("Favor de elegir un estudio");
		else
			$scope.generaReporte(fecha, tipoAbono, idEstudio);
	}

	$scope.generaReporte = function(fecha, tipoAbono, idEstudio) {
		var actionpath = null;
		var parametros = { fecha: fecha, tipoAbono: tipoAbono, claveReporte: 'RRS', idEstudio: idEstudio, validaEstatusCarga: $scope.validaEstatusCarga };

		var actionpath = '/reporte/revenuesplits/obtenerDatosReporte.action';

		utileriasService.actionCall(actionpath, parametros).then(function(data) {

			if (data.errorMensaje != null) {
				showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
				$scope.muestraInformacion = false;
			}
			else {
				$scope.tabla = data.reporteVista.tabla;
				$scope.header = data.reporteVista.header;
				$scope.columnCfg = data.reporteVista.columnCfg;
				$scope.muestraInformacion = true;
			}
		},
			function(error) {
				showError("Ha ocurrido el siguiente error: " + error);
				$scope.muestraInformacion = false;
			});

	}


	$scope.descargaReporte = function(fecha, tipoAbono, claveReporte, idEstudio) {
		var url = contextPath + '/reporte/revenuesplits/exportaReporte.action?fecha=' + fecha + '&tipoAbono=' + tipoAbono + '&claveReporte=' + claveReporte + '&idEstudio=' + idEstudio + '&validaEstatusCarga=' + $scope.validaEstatusCarga;
		try { window.open(url); }
		catch (e) { showError("Ha ocurrido el siguiente error: " + e.description); }

	}

	$scope.imprime = function(idDivPrintArea, fecha) {

		$("#" + idDivPrintArea).printThis({
			importCSS: true,
			importStyle: true,
			header: "<h3 style='width: 950px; font-weight:bold;'><img style='padding-right: 50px;' src='" + contextPath + "/design/img/common/Clarovideo.png'/>REPORTE REVENUE Y SPLITS DE " + utileriasService.getMes(fecha) + " - " + utileriasService.getAnio(fecha) + "</h3>"

		});

	}

	$scope.mostrarColumna = function(columna) {
		if (bypassColumnaConfig(columna, []))
			return false;
		if (bypassColumnaConfig(columna, ['ASSET_NAME']))
			return true;
		if ($scope.columnCfg == null || $scope.columnCfg.length == 0)
			return true
		for (var i = 0; i < $scope.columnCfg.length; i++)
			if ($scope.columnCfg[i] == mapeoColumnaConfiguracion(columna))
				return true;
		return false;
	}

	function mapeoColumnaConfiguracion(columna) {
		return columna;
	}

	function bypassColumnaConfig(columna, excepciones) {
		if ($.inArray(columna, excepciones) > -1) return true;
		return false;
	}

	$scope.obtenEstilo = function(row, column, x, y, tlength) {

		var styles = {};

		if ((x + 1) == tlength)
			styles['background-color'] = "#FFFFCF";
		else if ($scope.esStringVacio(row[0].valor))
			styles['background-color'] = "#DBDBDB";

		if ($.inArray(column.cname, ['ASSET_NAME']) > -1)
			if ($scope.esStringVacio(row[0].valor))
				styles['text-align'] = "right";
			else
				styles['text-align'] = "left";
		else if ($.inArray(column.cname, ['REGION', 'COUNTRY', 'REVENUE']) > -1)
			styles['text-align'] = "center";
		else
			styles['text-align'] = "right";

		if ($scope.esStringVacio(row[0].valor))
			styles['font-weight'] = "bold";
		return styles;
	}

	$scope.obtenFiltro = function(item, row, column, x, y, tlength) {

		if ($.inArray(column.cname, ['VAT', 'TOTAL', 'MES']) > -1)
			item = $filter('number')(item, 2);
		else if ($.inArray(column.cname, ['REVENUE']) > -1 && !$scope.esStringVacio(row[0].valor))
			item = $filter('number')(item, 1) + '%';

		return item;
	};

	$scope.esStringVacio = function(valor) {
		return valor ? valor.trim().length == 0 : true;
	}

	$scope.cambioFecha = function() {
		$scope.muestraInformacion = false;
	}


}

registraController("reporteRevenueYSplitsController", reporteRevenueYSplitsController);
