/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.titulo.bos;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.common.bos.CommonRestBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDmDAO;
import com.mx.dla.dda.contrato.titulo.daos.TitulosAmortizacionDAO;
import com.mx.dla.dda.contrato.titulo.dtos.DatosAmortizacion;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulos.dtos.PresupuestoTitulo;
import com.mx.dla.dda.contrato.ws.validapresupuesto.ResponseValidaPresupuestoCntDTO;
import com.mx.dla.dda.contrato.ws.validarMinimoSeleccion.ResponseValidaMinimoSeleccionDTO;
import com.mx.dla.global.bos.BaseBO;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TituloAsyncBO
extends BaseBO {
    @Autowired
    protected CatalogosDAO catalogosDAO;
    @Autowired
    private TituloDmDAO tituloDmDAO;
    @Autowired
    private TitulosAmortizacionDAO titulosAmortizacionDAO;
    @Autowired
    private CommonRestBO commonRestBO;
    public static DecimalFormat currency = new DecimalFormat("$###,###,###,###.##");
    public static DecimalFormat numeric = new DecimalFormat("###,###,###,###.##");

    public List<CatalogoDTO> buscaCategoriasDDATodas(ContratoDTO ct) {
        List cat = this.catalogosDAO.buscarCategoriaPagoTodosLosPeriodos(ct.getIdContrato());
        return cat;
    }

    public List<CatalogoDTO> buscaListas(ContratoDTO ct) {
        return this.catalogosDAO.buscarListasByContrato(ct.getIdContrato(), "M");
    }

    public List<CatalogoDTO> buscaCategoriasDDAFecha(ContratoDTO ct) {
        return this.catalogosDAO.buscarCategoriaPago(ct.getIdContrato());
    }

    public List<CatalogoDTO> buscaCategoriaContrato(ContratoDTO ct) {
        return this.catalogosDAO.buscaCategoriasPorContrato(ct.getIdContrato());
    }

    public List<String> buscaSugerencias(ContratoDTO ct) {
        List cat = this.catalogosDAO.buscarListaTitlosPorEstudio(ct.getIdEstudio());
        return cat;
    }

    public List<String> buscaSugerenciasCategoria(ContratoDTO ct) {
        List cat = this.catalogosDAO.buscarCategoriaPagoTodosLosPeriodos(ct.getIdContrato());
        ArrayList<String> c = new ArrayList<String>();
        for (CatalogoDTO ca : cat) {
            c.add(ca.getDesc());
        }
        return c;
    }

    public PresupuestoTitulo buscarPresupuesto(ContratoDTO ct, Lista l, String origen) {
        ArrayList errors = new ArrayList();
        ArrayList mensajes = new ArrayList();
        PresupuestoTitulo p = new PresupuestoTitulo();
        this.logger.debug("----------------------------------------");
        Long totalT = this.tituloDmDAO.cuentaTitulosPorListaYDescTitulo(l.getIdLista(), null, "T");
        this.logger.debug("Total Titulos [{}]", (Object)totalT);
        if (totalT != 0L) {
            try {
                ResponseValidaPresupuestoCntDTO resp = new ResponseValidaPresupuestoCntDTO();
                resp = this.commonRestBO.validaPresupuesto(ct.getFechaInicio(), ct.getIdContrato(), origen);
                p.setAnioAmortizacion(String.valueOf(ct.getAnioAmortizacion()));
                Double monto = Double.parseDouble("0");
                Double otro = Double.parseDouble("0");
                Double diff = monto - otro;
                this.logger.debug("monto {} otro {} ", (Object)monto, (Object)otro);
                this.logger.debug("diff {} en string {}", (Object)diff, (Object)diff.toString());
                p.setAmortizableEstudio(currency.format(monto));
                p.setComprometidoEstudiod(currency.format(otro));
                p.setDisponibleEstudio(currency.format(diff));
                this.logger.info("{}", (Object)resp);
                if (!resp.getResultado()) {
                    p.setAdvertencias(resp.getMensaje());
                }
                if (resp.getResultado() && resp.getMensaje() != null) {
                    p.setMensajes(resp.getMensaje());
                }
            }
            catch (Exception e) {
                this.logger.error("Error ", (Throwable)e);
                p.setErrores(Arrays.asList("Ocurri\u00f3 un error en la validaci\u00f3n de presupuesto"));
            }
            try {
                ResponseValidaMinimoSeleccionDTO respmin = this.commonRestBO.validaMinimos(ct, origen);
                this.logger.info("{}", (Object)respmin);
                if (!respmin.getResultado() && respmin.getErrores() != null) {
                    p.setAdvertencias(respmin.getErrores());
                }
            }
            catch (Exception e) {
                this.logger.error("Error ", (Throwable)e);
                p.setErrores(Arrays.asList("Ocurri\u00f3 un error en validar minimos de seleccion"));
            }
        }
        return p;
    }

    public DatosAmortizacion buscarDatosAmortizacion(ContratoDTO ct, Lista l) {
        DatosAmortizacion d = new DatosAmortizacion();
        Long total = this.tituloDmDAO.cuentaTitulosPorListaYDescTitulo(l.getIdLista(), null, "T");
        Double monto = this.tituloDmDAO.buscarTotalCostoTitulos(ct.getIdContrato(), "T");
        monto = monto == null ? 0.0 : monto;
        total = total == null ? 0L : total;
        this.logger.debug("Total [{}] Mondo[{}] ", (Object)total, (Object)monto);
        d.setTotalTitulos(numeric.format(total));
        d.setTotalMonto(currency.format(monto));
        List c = this.titulosAmortizacionDAO.buscarAniosAmortizacionContrato(ct.getIdContrato());
        d.setAmortizaciones(c);
        return d;
    }
}

