/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.titulos.bos;

import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.titulo.constants.TipoCambioTitulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.transaccion.titulos.bos.TituloTranRules;
import com.mx.dla.dda.contrato.transaccion.titulos.bos.TituloTranUtil;
import com.mx.dla.dda.contrato.transaccion.titulos.bos.TitulosBussinesTranBO;
import com.mx.dla.dda.contrato.transaccion.titulos.daos.TituloTransDAO;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransDB;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransaccionDTO;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TituloTranGridBO
extends BaseBO {
    @Autowired
    private TitulosBussinesTranBO titulosBussinesBO;
    @Autowired
    private TituloTranRules tituloRules;
    @Autowired
    private TituloTransDAO tituloDAO;
    private List<CatalogoDTO> filiales;
    private List<CatalogoDTO> categorias;
    private List<CatalogoDTO> generosA;
    private List<CatalogoDTO> generosB;
    private List<CatalogoDTO> tiers;
    private List<CatalogoDTO> catSeries;

    public String agregarTitulo(Long idContrato, Long idLista, TituloTransaccionDTO titulo) throws TituloException, Exception {
        String serie = null;
        titulo = this.obtenerDatosComplementarios(idLista, idContrato, titulo);
        this.logger.info("{}", (Object)titulo);
        this.tituloRules.validaEntrada(titulo);
        this.guardaTitulo(titulo);
        return serie;
    }

    public void altaSeriesAuto(Long idContrato, Long idLista, TituloTransaccionDTO titulo) throws TituloException {
        int numEpisodios = Integer.parseInt(titulo.getEpisodio());
        this.logger.debug("" + numEpisodios);
        String nombre = titulo.getNombreUnico() + ": Episodio # ";
        titulo = this.obtenerDatosComplementarios(idLista, idContrato, titulo);
        for (int i = 1; i <= numEpisodios; ++i) {
            String name = nombre + i;
            titulo.setNombreEstandar(name);
            titulo.setEpisodio("" + i);
            this.guardaTitulo(titulo);
        }
    }

    public TituloTransaccionDTO guardaTitulo(TituloTransaccionDTO titulo) throws TituloException {
        this.logger.debug("titulo a: {}", (Object)titulo);
        TituloTransDB tit = TituloTranUtil.TituloDTO2BD(titulo, this.filiales, this.categorias, this.generosA, this.generosB, this.tiers, this.catSeries);
        this.logger.debug("titulo b: {}", (Object)tit);
        this.tituloDAO.guardarTituloTrans(tit);
        titulo.setIdTituloCnt(tit.getIdTituloCnt());
        return titulo;
    }

    public void editarTitulo(Long idContrato, Long idLista, TituloTransaccionDTO titulo) throws TituloException, Exception {
        titulo = this.obtenerDatosComplementarios(idLista, idContrato, titulo);
        this.logger.info("{}", (Object)titulo);
        this.tituloRules.validaEntrada(titulo);
        if (!this.actualizarTituloEnmienda()) {
            TituloTransDB tit = TituloTranUtil.TituloDTO2BD(titulo, this.filiales, this.categorias, this.generosA, this.generosB, this.tiers, this.catSeries);
            this.logger.info("{}", (Object)tit);
            this.tituloDAO.editarTituloTrans(tit);
        }
    }

    public void eliminarTitulo(Long idTitulo) {
        this.tituloDAO.borrarTitulo(idTitulo);
    }

    public String cambioMultipleTitulo(Long idContrato, Long idLista, TituloTransaccionDTO titulo, List<Long> ids, String cambio) throws TituloException, Exception {
        String mensaje;
        block10: {
            Boolean bloque;
            block11: {
                block9: {
                    bloque = ids.size() < 1000;
                    mensaje = "";
                    titulo.setIdContrato(idContrato);
                    if (!TipoCambioTitulo.CATEGORIA.name().equals(cambio)) break block9;
                    this.logger.info("Categoria");
                    TituloTransDB tit = TituloTranUtil.TituloDTO2BD(titulo, this.filiales, this.categorias, this.generosA, this.generosB, this.tiers, this.catSeries);
                    if (bloque.booleanValue()) {
                        this.tituloDAO.actualizarCategoriaTrans(tit.getIdCategoria(), null, bloque, ids);
                    } else {
                        for (Long index : ids) {
                            this.tituloDAO.actualizarCategoriaTrans(tit.getIdCategoria(), index, bloque, null);
                        }
                    }
                    break block10;
                }
                if (!TipoCambioTitulo.VENTANA.name().equals(cambio)) break block11;
                this.logger.info("Ventana");
                this.tituloRules.validaVentanaTitulo(titulo);
                if (bloque.booleanValue()) {
                    this.tituloDAO.actualizarVentanaTrans(titulo.getFechaInicio(), titulo.getFechaFin(), null, bloque, ids);
                } else {
                    for (Long index : ids) {
                        this.tituloDAO.actualizarVentanaTrans(titulo.getFechaInicio(), titulo.getFechaFin(), index, bloque, null);
                    }
                }
                break block10;
            }
            if (!TipoCambioTitulo.HVRD.name().equals(cambio)) break block10;
            this.logger.info("Hvrd");
            this.logger.info("{}", ids);
            this.tituloRules.validaHvrdTitulo(titulo, TituloTranUtil.TituloBD2DTO(this.tituloDAO.obtenTitulos(ids, null, "M")));
            if (bloque.booleanValue()) {
                this.tituloDAO.actualizarHvrdTrans(titulo.getHvrd(), null, bloque, ids);
            } else {
                for (Long index : ids) {
                    this.tituloDAO.actualizarHvrdTrans(titulo.getHvrd(), index, bloque, null);
                }
            }
        }
        return mensaje;
    }

    public <T> void print(List<T> lista) {
        for (T item : lista) {
            this.logger.info("{}", item);
        }
    }

    public List<TituloTransaccionDTO> obtenerTitulos(String prefix, Long idLista) {
        ArrayList<TituloTransDB> titulos = new ArrayList<TituloTransDB>();
        List totalFila = this.tituloDAO.buscaTotalesListaTran(prefix, idLista);
        titulos.addAll(totalFila);
        this.logger.info("*** totalFila: {} +++");
        this.print(totalFila);
        this.logger.info("");
        List filasNoAgrupadas = this.tituloDAO.buscaDetallePeliculasTran(idLista);
        titulos.addAll(filasNoAgrupadas);
        this.logger.info("*** filasPeliculas: {} +++");
        this.print(filasNoAgrupadas);
        this.logger.info("");
        List titulosCapitulo1 = this.tituloDAO.buscaSeries1CapituloTrans(idLista, prefix);
        this.logger.info("*** filasUnCapitulo: {} +++");
        this.print(titulosCapitulo1);
        this.logger.info("");
        List titulosAgrupados = this.tituloDAO.buscaTotalesSerie(idLista, null, prefix);
        this.logger.info("*** titulosAgrupados: {} +++");
        this.print(titulosAgrupados);
        this.logger.info("");
        List<TituloTransDB> titulosRestados = this.removerSeries1Capitulo(titulosCapitulo1, titulosAgrupados);
        titulos.addAll(titulosRestados);
        this.logger.info("*** titulosRestados: {} +++");
        this.print(titulosRestados);
        this.logger.info("");
        ArrayList<TituloTransaccionDTO> titulosDto = new ArrayList<TituloTransaccionDTO>();
        for (TituloTransDB t : titulos) {
            titulosDto.add(TituloTranUtil.TituloBD2DTO(t));
        }
        this.logger.info("*** titulosTransformados: {} +++");
        this.print(titulosDto);
        return titulosDto;
    }

    public List<TituloTransDB> removerSeries1Capitulo(List<TituloTransDB> titulosCapitulo1, List<TituloTransDB> titulosAgrupados) {
        ArrayList<TituloTransDB> titulos = new ArrayList<TituloTransDB>();
        block0: for (TituloTransDB s : titulosCapitulo1) {
            int i = 0;
            for (TituloTransDB tt : titulosAgrupados) {
                if (tt.getNombreUnico().equals(s.getNombreUnico())) {
                    titulosAgrupados.remove(i);
                    continue block0;
                }
                ++i;
            }
        }
        titulos.addAll(titulosCapitulo1);
        titulos.addAll(titulosAgrupados);
        return titulos;
    }

    public List<TituloTransaccionDTO> obtenerTitulosSeries(String prefix, Long idLista, String nombreUnico) {
        ArrayList titulos = new ArrayList();
        titulos.addAll(this.tituloDAO.buscaTotalesSerie(idLista, nombreUnico, prefix));
        titulos.addAll(this.tituloDAO.buscaDetalleSeriesTran(idLista, nombreUnico));
        ArrayList<TituloTransaccionDTO> titulosDto = new ArrayList<TituloTransaccionDTO>();
        for (TituloTransDB t : titulos) {
            titulosDto.add(TituloTranUtil.TituloBD2DTO(t));
        }
        if (!titulosDto.isEmpty()) {
            ((TituloTransaccionDTO)titulosDto.get(0)).setAgrupable(Integer.valueOf(0));
        }
        return titulosDto;
    }

    public List<TituloTransaccionDTO> listarPrincipalTitulos(String prefix, Long idLista) {
        TituloTransaccionDTO parametros = new TituloTransaccionDTO();
        parametros.setIdLista(idLista);
        this.logger.info("listarPrincipalTitulos");
        ArrayList<TituloTransDB> titulos = new ArrayList<TituloTransDB>();
        titulos.addAll(this.tituloDAO.listaTitulosPrincipal(parametros, "L"));
        this.logger.info("{}", titulos);
        return TituloTranUtil.TituloBD2DTO(titulos);
    }

    public List<TituloTransaccionDTO> listarSeriesTitulos(String prefix, Long idLista, String nombreUnico) {
        TituloTransaccionDTO parametros = new TituloTransaccionDTO();
        parametros.setIdLista(idLista);
        parametros.setNombreUnico(nombreUnico);
        this.logger.info("listarSeriesTitulos");
        ArrayList<TituloTransDB> titulos = new ArrayList<TituloTransDB>();
        titulos.addAll(this.tituloDAO.listaTitulosPrincipal(parametros, "H"));
        this.logger.info("{}", titulos);
        titulos.addAll(this.tituloDAO.listaTitulosSeries(parametros, "L"));
        this.logger.info("{}", titulos);
        return TituloTranUtil.TituloBD2DTO(titulos);
    }

    public List<TituloTransaccionDTO> listarDetalleTitulos(String prefix, Long idLista, String nombreUnico, String idBv) {
        TituloTransaccionDTO parametros = new TituloTransaccionDTO();
        parametros.setIdLista(idLista);
        parametros.setNombreUnico(nombreUnico);
        parametros.setIdBv(idBv);
        this.logger.info("listarDetalleTitulos");
        ArrayList<TituloTransDB> titulos = new ArrayList<TituloTransDB>();
        titulos.addAll(this.tituloDAO.listaTitulosSeries(parametros, "H"));
        this.logger.info("{}", titulos);
        titulos.addAll(this.tituloDAO.listaTitulosDetalle(parametros));
        this.logger.info("{}", titulos);
        return TituloTranUtil.TituloBD2DTO(titulos);
    }

    public List<TituloTransaccionDTO> titulosEnLista(Long idLista, String prefix) {
        return TituloTranUtil.TituloBD2DTO(this.tituloDAO.obtenTitulos(null, Arrays.asList(idLista), prefix));
    }

    public boolean actualizarTituloEnmienda() {
        return false;
    }

    public TituloTransaccionDTO obtenerDatosComplementarios(Long idLista, Long idContrato, TituloTransaccionDTO titulo) {
        titulo.setIdLista(idLista);
        titulo.setIdContrato(idContrato);
        return titulo;
    }

    public void obtenerCatalogos(Long idContrato) {
        this.filiales = this.tituloDAO.obtenerFiliales(idContrato);
        this.categorias = this.tituloDAO.obtenerCategorias(idContrato);
        this.generosA = this.tituloDAO.obtenerGeneros();
        this.generosB = this.tituloDAO.obtenerGeneros();
        this.tiers = this.tituloDAO.obtenerTiers();
        this.catSeries = this.tituloDAO.obtenerCatSeries();
    }

    public List<CatalogoDTO> getFiliales() {
        return this.filiales;
    }

    public List<CatalogoDTO> getCategorias() {
        return this.categorias;
    }

    public List<CatalogoDTO> getGenerosA() {
        return this.generosA;
    }

    public List<CatalogoDTO> getGenerosB() {
        return this.generosB;
    }

    public List<CatalogoDTO> getTiers() {
        return this.tiers;
    }

    public List<CatalogoDTO> getCatSeries() {
        return this.catSeries;
    }
}

